package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;

/**
 * <p>
 * Ao de menu popup que dispara a viso do configurador de algoritmos para que
 * o usurio preencha os parmetros.
 * </p>
 * 
 * @author lmoreira
 */
public final class AskForParameterValuesAction extends GraphElementAction {
  /**
   * Cria a ao.
   * 
   * @param node O n (No aceita {@code null}).
   */
  public AskForParameterValuesAction(final GraphNode node) {
    super(node, AskForParameterValuesAction.class.getName() + ".name",
      ApplicationImages.ICON_EDITPARAMS_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent e) {
    final GraphNode node = (GraphNode) getElement();
    node.askForParameterValues();
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    return new AddNodePopupActionFilter(workspace) {

      @Override
      protected Action createAction(final GraphNode graphNode,
        final Point2D point) {
        return new AskForParameterValuesAction(graphNode);
      }
    };
  }
}
