package csbase.client.csdk.v2.eventlog;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import csbase.logic.eventlogservice.LogsInfo;
import csdk.v2.extras.context.ILogsInfo;

/**
 * Encapsula os dados de uma pesquisa dos logs (obtidos do servio de logs de
 * eventos) em um objeto acessvel pelas aplicaes baseadas no CSDK.
 */
public class CSDKLogsInfo implements ILogsInfo {

  /**
   * Dados de log encapsulados.
   */
  private final LogsInfo info;

  /**
   * Construtor
   * 
   * @param info dados de log encapsulado.
   */
  public CSDKLogsInfo(LogsInfo info) {
    if (info == null) {
      throw new IllegalArgumentException("Parmetro info no pode ser nulo");
    }
    this.info = info;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Date getStartDate() {
    return info.getStartDate();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Date getEndDate() {
    return info.getEndDate();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<String[]> getLoginTable() {
    return info.getLoginTable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<String[]> getApplicationsTable() {
    return info.getApplicationsTable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<String[]> getExecutionsTable() {
    return info.getExecutionsTable();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Set<String> getApplications() {
    return info.getApplications();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Set<String> getAlgorithms() {
    return info.getAlgorithms();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, Integer> getExecutionsByUser(List<String> filterAlgorithms) {
    return info.getExecutionsByUser(filterAlgorithms);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, Integer> getExecutionsByAlgorithm(
    List<String> filterAlgorithms) {
    return info.getExecutionsByAlgorithm(filterAlgorithms);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Map<String, Integer> getLoginsByUser() {
    return info.getLoginsByUser();
  }

}
