package csbase.client.csdk.v2.extras.rest;

import org.glassfish.jersey.server.ResourceConfig;

import csbase.client.csdk.v2.core.CSDKAbstractContext;
import csbase.client.rest.RestController;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v2.extras.context.rest.IRestContext;
import csdk.v2.extras.context.rest.RestException;
import tecgraf.javautils.core.lng.LNG;

/**
 * Implementao do contexto REST do CSDK no ambiente, que permite basicamente o
 * registro/desregistro de recursos REST da aplicao no cliente.
 */
public class CSDKRestContext extends CSDKAbstractContext implements
  IRestContext {

  /**
   * Prefixo para recursos REST.
   */
  private final String prefix;

  /**
   * Construtor.
   *
   * @param instanceId identificador da instncia da aplicao.
   * @param registry registro da aplicao.
   */
  public CSDKRestContext(String instanceId, ApplicationRegistry registry) {
    this.prefix = registry.getId() + "/" + instanceId;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void registerResources(
    ResourceConfig resourceConfig) throws RestException {
    RestController restController = RestController.getInstance();
    if (!resourceConfig.getInstances().isEmpty() && resourceConfig
      .getClasses().isEmpty()) {
      restController
        .addApplicationResources(prefix, resourceConfig);
    }
    else {
      String errorMsg =
        LNG.get(CSDKRestContext.class.getSimpleName() + ".rest.register.error");
      throw new RestException(errorMsg);
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void unregisterResources() {
    RestController restController = RestController.getInstance();
    restController.removeApplicationResources(prefix);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void contextDeactivated() {
    unregisterResources();
  }
}
