package csbase.client.desktop;

import csbase.client.util.NotificationTranslator;
import csbase.logic.UserNotification;

/**
 * A classe BasicNotificationPanel  uma implementao bsica do painel de
 * notificaes.
 * 
 * @author Tecgraf
 */
public class BasicNotificationPanel extends NotificationPanel {
  /**
   * O tradutor
   */
  private NotificationTranslator translator = null;

  /**
   * Obtm um tradutor para as notificaes enviadas pelo servidor, exibidas no
   * painel de notificaes do desktop.
   * 
   * @return referncia para o tradutor das notificaes
   */
  @Override
  public NotificationTranslator getTranslator() {
    if (translator == null) {
      translator = new NotificationTranslator() {
        @Override
        public String translate(UserNotification data) {
          return data.toString();
        }
      };
    }
    return translator;
  }
}
