package csbase.client.util.table;

/**
 * Observador de {@link RowModel}.
 * 
 * @param <R> O valor armazenado na linha.
 *
 * @author lmoreira
 */
public interface RowModelListener<R> {

  /**
   * Indica que uma linha foi adicionada.
   * 
   * @param newRowValue O valor da linha.
   * 
   * @param newRowIndex O ndice da linha.
   */
  public void rowWasAdded(R newRowValue, int newRowIndex);

  /**
   * Indica que uma linha foi removida.
   * 
   * @param oldRowValue O valor da linha.
   * 
   * @param oldRowIndex O ndice da linha.
   */
  public void rowWasRemoved(R oldRowValue, int oldRowIndex);
}
