/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.actions;

import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.FlowApplicationUI;
import csbase.client.applications.flowapplication.FlowTransferable;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.actions.FlowApplicationAction;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.messages.CheckClipboardFlavorMessage;
import csbase.client.applications.flowapplication.messages.PasteMessage;
import csbase.client.applications.flowapplication.messages.SelectElementsMessage;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.util.Collection;
import tecgraf.vix.TypeMessage;
import tecgraf.vix.TypeVO;
import tecgraf.vix.TypeVS;

public class PasteElementsAction
extends FlowApplicationAction
implements FlavorListener {
    public PasteElementsAction(FlowApplication application) {
        super(application, FlowApplicationUI.PASTE_NODE_ICON);
        this.updateEnabledStatus();
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        FlowApplication application = (FlowApplication)this.getApplication();
        Workspace workspace = application.getWorkspace();
        Graph graph = workspace.getGraph();
        PasteMessage pasteMessage = new PasteMessage();
        pasteMessage.sendVS((TypeVS)graph);
        if (pasteMessage.getTransferable() != null) {
            pasteMessage.sendVO((TypeVO)graph);
            Collection<GraphElement> elements = pasteMessage.getAffectedElements();
            if (elements != null) {
                workspace.sendVO((TypeMessage)new SelectElementsMessage(elements));
            }
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.updateEnabledStatus();
    }

    private void updateEnabledStatus() {
        FlowApplication application = (FlowApplication)this.getApplication();
        Workspace workspace = application.getWorkspace();
        Graph graph = workspace.getGraph();
        boolean canPaste = CheckClipboardFlavorMessage.canPasteFromClipboard((TypeVS)graph, FlowTransferable.DATA_FLAVOR);
        this.setEnabled(canPaste);
    }
}

