/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree;

import csbase.client.applications.algorithmsmanager.versiontree.AbstractFileInfoNode;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.EditReleaseNotesFileAction;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportReleaseNotesFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveReleaseNotesFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ReleaseNotesPathFactory;
import java.awt.datatransfer.DataFlavor;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class ReleaseNotesFileNode
extends AbstractFileInfoNode {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(ReleaseNotesFileNode.class, ReleaseNotesFileNode.class.getSimpleName());

    protected ReleaseNotesFileNode(VersionTree tree, AlgorithmVersionInfo version, FileInfo file) {
        super(tree, version, file, file1 -> new ReleaseNotesFileNode(tree, version, file1), false);
    }

    @Override
    public JPopupMenu createPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new RemoveReleaseNotesFile(this.getTree(), this.getVersion(), this.getSelectedFiles()))));
        if (!this.getFile().isDirectory()) {
            popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new ExportReleaseNotesFile(this.getTree(), this.getVersion(), this.getFile()))));
            if (this.getTree().getSelectionCount() == 1) {
                popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new EditReleaseNotesFileAction(this.getTree(), this.getVersion(), this.getFile()))));
            }
        }
        return popupMenu;
    }

    @Override
    public DataFlavor getDataFlavor() {
        return DATA_FLAVOR;
    }

    @Override
    protected final IPathFactory createSourcePathFactory(AbstractFileInfoNode.DataTransferObject dto) {
        AlgorithmVersionInfo sourceVersion = dto.getVersion();
        return new ReleaseNotesPathFactory(sourceVersion);
    }

    @Override
    protected final IPathFactory createTargetPathFactory() {
        return new ReleaseNotesPathFactory(this.getVersion());
    }
}

