/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.actions;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;
import java.util.List;
import java.util.Set;

class DefineUsersTask
extends ProjectsManagerTask<Void> {
    private final List<ProjectsManagerData> projects;
    private final Set<Object> usersRO;
    private final Set<Object> usersRW;

    public DefineUsersTask(ProjectsManager projectsManager, List<ProjectsManagerData> projects, Set<Object> usersRO, Set<Object> usersRW) {
        super(projectsManager);
        this.projects = projects;
        this.usersRO = usersRO;
        this.usersRW = usersRW;
    }

    protected void performTask() throws Exception {
        if (this.usersRO == null && this.usersRW == null) {
            return;
        }
        ProjectServiceInterface psi = ClientRemoteLocator.projectService;
        for (ProjectsManagerData pmd : this.projects) {
            CommonClientProject ccp = psi.openProject(pmd.getProjectId(), false);
            ccp.updateUsers(ProjectPermissions.SharingType.PARTIAL, this.usersRO, this.usersRW);
            ccp.close(true);
        }
    }
}

