/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.table;

import csbase.client.util.table.CellModel;
import csbase.client.util.table.CellModelListener;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractCellModel
implements CellModel {
    private List<CellModelListener> listeners = new LinkedList<CellModelListener>();

    protected AbstractCellModel() {
    }

    @Override
    public final void addCellModelListener(CellModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    @Override
    public final void removeCellModelListener(CellModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.remove(listener);
    }

    @Override
    public final boolean setValue(Object value) {
        Object currentValue = this.getValue();
        if (value == null ? currentValue == null : value.equals(currentValue)) {
            return false;
        }
        this.keepValue(value);
        this.fireValueWasChanged();
        return true;
    }

    protected abstract void keepValue(Object var1);

    private final void fireValueWasChanged() {
        for (CellModelListener listener : this.listeners) {
            listener.valueWasChanged(this);
        }
    }
}

