/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.newview;

import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent;
import csbase.client.algorithms.commands.newview.CommandView;
import csbase.client.algorithms.commands.newview.CommandViewType;
import csbase.client.algorithms.commands.newview.LogTabConfiguration;
import csbase.client.algorithms.commands.newview.MatchLogTabConfigurationsTask;
import csbase.client.algorithms.commands.newview.ParametersTab;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.AutoReloadable;
import csbase.client.util.gui.log.LogPanelReloader;
import csbase.client.util.gui.log.tab.AbstractLogTab;
import csbase.client.util.gui.log.tab.AbstractTab;
import csbase.client.util.gui.log.tab.ConsolidatedLogTab;
import csbase.client.util.gui.log.tab.ReloadableTab;
import csbase.client.util.gui.log.tab.SimpleLogTab;
import csbase.client.util.gui.log.tab.Tab;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandFinalizationInfo;
import csbase.logic.CommandFinalizationType;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import csbase.logic.CommandViewPermission;
import csbase.logic.ProgressData;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmConfigurator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.StatusBar;
import tecgraf.javautils.gui.SwingThreadDispatcher;

abstract class AbstractCommandView
implements CommandView {
    protected StatusBar statusBar;
    protected Tab selected;
    protected JTabbedPane tabbedPane;
    protected CommandInfo command;
    protected AlgorithmConfigurator configurator;
    protected DesktopComponentFrame owner;
    protected CommandViewType viewType;
    protected JPanel mainPanel;
    protected final Map<String, Tab> staticTabs;
    protected final Map<String, ReloadableTab> reloadableTabs;
    private static final String LOG_TAB_ID_PROPERTY_NAME = "tab.{0}.id";
    private static final String LOG_TAB_TITLE_PROPERTY_NAME = "tab.{0}.title.{1}";
    private static final String LOG_TAB_FILE_PATTERN_PROPERTY_NAME = "tab.{0}.log.file.pattern.{1}";
    private static final String LOG_TAB_RESTRICTED_PROPERTY_NAME = "tab.{0}.restricted";
    private static final String ID_REPLACEMENT_TAG = "$ID";
    protected String idForLogPattern;

    public AbstractCommandView(CommandViewType viewType, CommandInfo command, AlgorithmConfigurator configurator) throws ClientException {
        if (command == null) {
            throw new IllegalArgumentException("O par\u00e2metro command est\u00e1 nulo.");
        }
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        this.viewType = viewType == null ? CommandViewType.SIMPLE : viewType;
        this.idForLogPattern = null;
        this.command = command;
        this.configurator = configurator;
        this.reloadableTabs = new HashMap<String, ReloadableTab>();
        this.staticTabs = new HashMap<String, Tab>();
    }

    @Override
    public Component getMainComponent(DesktopComponentFrame window) throws ClientException {
        if (this.mainPanel == null) {
            this.owner = window;
            this.initUI();
        }
        return this.mainPanel;
    }

    private void initUI() throws ClientException {
        List<LogTabConfiguration> tabConfiguration;
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.statusBar = new StatusBar();
        this.statusBar.showStatusBar();
        try {
            tabConfiguration = this.getLogTabsConfiguration();
        }
        catch (ConfigurationManagerException e) {
            throw new ClientException(this.getString("error.loading.tab.configuration"), e);
        }
        this.tabbedPane = new JTabbedPane();
        this.createTabs(tabConfiguration);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractCommandView.this.updateSelection();
            }
        });
        this.mainPanel.add((Component)this.tabbedPane, "Center");
        JPanel southPane = new JPanel(new BorderLayout());
        southPane.add((Component)this.statusBar, "South");
        this.mainPanel.add((Component)southPane, "South");
        this.updateStatusBar();
    }

    private void updateSelection() {
        Tab currrentSelection = this.selected;
        int index = this.tabbedPane.getSelectedIndex();
        String title = this.tabbedPane.getTitleAt(index);
        if (currrentSelection != null && !currrentSelection.getTitle().equals(title)) {
            currrentSelection.setSelected(false);
            this.selected = null;
        }
        if (this.selected == null) {
            this.selected = this.getTabByTitle(title);
        }
        if (this.selected != null) {
            this.selected.setSelected(true);
            this.updateStatusBar();
        }
    }

    private boolean hasLogsTab() {
        ConfigurationManager cnfManager = ConfigurationManager.getInstance();
        boolean defaultValue = false;
        if (cnfManager == null) {
            return false;
        }
        try {
            Class<LogTabConfiguration> propClass = LogTabConfiguration.class;
            Configuration cnf = cnfManager.getConfiguration(propClass);
            String propName = "enabled";
            Boolean isEnabled = cnf.getOptionalBooleanProperty(propName, false);
            return isEnabled;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected ProgressData getCommandProgress() {
        return this.command.getProgressData();
    }

    private void createTabs(List<LogTabConfiguration> tabConfiguration) throws ClientException {
        Map<String, ReloadableTab> relTabs;
        this.tabbedPane.removeAll();
        Map<String, Tab> statTabs = this.createStaticTabs();
        if (statTabs != null) {
            for (Map.Entry<String, Tab> entry : statTabs.entrySet()) {
                String title = entry.getKey();
                Tab tab = entry.getValue();
                if (tab != null) {
                    this.tabbedPane.addTab(title, tab.getMainComponent());
                }
                this.staticTabs.put(title, tab);
            }
        }
        if ((relTabs = this.createReloadableTabs(tabConfiguration)) != null) {
            for (LogTabConfiguration conf : tabConfiguration) {
                String title = conf.getTitle();
                ReloadableTab tab = relTabs.get(title);
                if (tab != null) {
                    this.tabbedPane.addTab(title, tab.getMainComponent());
                }
                this.reloadableTabs.put(title, tab);
            }
        }
        Dimension dimension = new Dimension(600, 300);
        this.mainPanel.setPreferredSize(dimension);
    }

    protected Map<String, Tab> createStaticTabs() throws ClientException {
        HashMap<String, Tab> tabs = new HashMap<String, Tab>();
        Tab detailsTab = this.createDetailsTab();
        if (detailsTab != null) {
            tabs.put(detailsTab.getTitle(), detailsTab);
        }
        return tabs;
    }

    protected Tab createDetailsTab() throws ClientException {
        String title = this.getString("tab.details.title");
        return new ParametersTab(this.configurator, title, (Window)this.owner);
    }

    private String getString(String key) {
        return LNG.getAnyOf((String[])new String[]{this.getClass().getSimpleName() + "." + key, AbstractCommandView.class.getSimpleName() + "." + key});
    }

    private String getString(String key, Object ... keyArgs) {
        return MessageFormat.format(this.getString(key), keyArgs);
    }

    protected Map<String, ReloadableTab> createReloadableTabs(List<LogTabConfiguration> tabConfiguration) {
        if (this.hasLogsTab()) {
            return this.createLogTabs(tabConfiguration);
        }
        return Collections.emptyMap();
    }

    protected Map<String, ReloadableTab> createLogTabs(List<LogTabConfiguration> tabConfiguration) {
        HashMap<String, ReloadableTab> logTabs = new HashMap<String, ReloadableTab>();
        Map<LogTabConfiguration, Set<ClientProjectFile>> matchMap = this.getMatchingLogFiles(tabConfiguration);
        if (matchMap != null) {
            for (LogTabConfiguration conf : tabConfiguration) {
                boolean autoReloadTab;
                String title = conf.getTitle();
                Set<ClientProjectFile> matchingFiles = matchMap.get(conf);
                boolean bl = autoReloadTab = !this.isCommandFinished();
                AbstractLogTab logTab = matchingFiles == null || matchingFiles.size() == 0 ? null : (matchingFiles.size() > 1 ? new ConsolidatedLogTab(title, matchingFiles, this.statusBar, this.owner, autoReloadTab) : new SimpleLogTab(title, matchingFiles.iterator().next(), this.statusBar, this.owner, autoReloadTab));
                if (logTab == null) continue;
                logTabs.put(title, logTab);
            }
        }
        return logTabs;
    }

    protected List<LogTabConfiguration> getLogTabsConfiguration() throws ConfigurationManagerException {
        ConfigurationManager cnfManager = ConfigurationManager.getInstance();
        if (cnfManager == null) {
            return Collections.emptyList();
        }
        ArrayList<LogTabConfiguration> configurations = new ArrayList<LogTabConfiguration>();
        Class<LogTabConfiguration> propClass = LogTabConfiguration.class;
        Configuration cnf = cnfManager.getConfiguration(propClass);
        if (cnf == null) {
            return Collections.emptyList();
        }
        User loggedUser = User.getLoggedUser();
        boolean isAdmin = loggedUser.isAdmin();
        boolean continueReading = true;
        int i = 1;
        while (continueReading) {
            String tabId = cnf.getOptionalProperty(MessageFormat.format(LOG_TAB_ID_PROPERTY_NAME, i));
            if (tabId != null) {
                boolean hasPermission;
                boolean isRestricted;
                String title = cnf.getMandatoryProperty(MessageFormat.format(LOG_TAB_TITLE_PROPERTY_NAME, tabId, LNG.getLocale()));
                ArrayList<String> filePatterns = cnf.getMandatoryListProperty(MessageFormat.format(LOG_TAB_FILE_PATTERN_PROPERTY_NAME, tabId, this.viewType.getPropertyName()));
                if (this.idForLogPattern != null) {
                    ArrayList<String> replacedPatterns = new ArrayList<String>();
                    for (String pattern : filePatterns) {
                        String replacedPattern = pattern.replace(ID_REPLACEMENT_TAG, this.idForLogPattern);
                        replacedPatterns.add(replacedPattern);
                    }
                    filePatterns = replacedPatterns;
                }
                if ((isRestricted = cnf.getOptionalBooleanProperty(MessageFormat.format(LOG_TAB_RESTRICTED_PROPERTY_NAME, tabId), false).booleanValue()) && !isAdmin) {
                    try {
                        hasPermission = CommandViewPermission.checkCommandViewPermission((User)loggedUser, (String)tabId);
                    }
                    catch (Exception e) {
                        hasPermission = false;
                        StandardDialogs.showErrorDialog((Component)this.mainPanel.getParent(), (String)this.getTitle(), (String)this.getString("error.checking.permission", this.command.getId()));
                    }
                } else {
                    hasPermission = true;
                }
                if (hasPermission) {
                    configurations.add(new LogTabConfiguration(tabId, title, filePatterns, isRestricted));
                }
            } else {
                continueReading = false;
            }
            ++i;
        }
        return configurations;
    }

    protected Map<LogTabConfiguration, Set<ClientProjectFile>> getMatchingLogFiles(List<LogTabConfiguration> tabConfiguration) {
        String[] logsDir = this.command.getPersistencyPath();
        MatchLogTabConfigurationsTask task = new MatchLogTabConfigurationsTask(logsDir, tabConfiguration);
        if (task.execute(this.owner, this.getTitle(), this.getString("message.loading.logs"))) {
            return (Map)task.getResult();
        }
        StandardDialogs.showErrorDialog((Component)this.mainPanel.getParent(), (String)this.getTitle(), (String)this.getString("error.loading.logs", this.command.getId()));
        return null;
    }

    @Override
    public String getTitle() {
        return this.command.getId();
    }

    private void updateStatusBar() {
        String statusMessage;
        switch (this.command.getStatus()) {
            case SCHEDULED: {
                statusMessage = this.getString("message.status.scheduled");
                break;
            }
            case FINISHED: {
                statusMessage = this.getFinalizationTypeDescription();
                break;
            }
            case SYSTEM_FAILURE: {
                statusMessage = this.getString("message.status.system_failure");
                break;
            }
            case EXECUTING: 
            case INIT: 
            case UPLOADING: 
            case DOWNLOADING: {
                if (this.command.isValid()) {
                    if (this.command.isQueued()) {
                        statusMessage = this.getString("message.status.queued");
                        break;
                    }
                    ProgressData data = this.getCommandProgress();
                    if (data != null) {
                        statusMessage = this.getString("message.status.running.progress", data.getDescription());
                        break;
                    }
                    statusMessage = this.getString("message.status.running");
                    break;
                }
                statusMessage = this.getString("message.status.disconnected");
                break;
            }
            default: {
                statusMessage = this.getString("message.status.unknown");
            }
        }
        this.statusBar.setStatus(statusMessage);
    }

    protected String getFinalizationTypeDescription() {
        CommandFinalizationInfo finalizationInfo = this.command.getFinalizationInfo();
        CommandFinalizationType finalizationType = finalizationInfo.getFinalizationType();
        Integer exitCode = finalizationInfo.getExitCode();
        String description = this.getFinalizationTypeDescription(finalizationType, exitCode);
        if (this.command.hasWarnings()) {
            description = description + " " + this.getString("message.status.warning");
        }
        return description;
    }

    protected String getFinalizationTypeDescription(CommandFinalizationType finalizationType, Integer exitCode) {
        switch (finalizationType) {
            case END: {
                return this.getString("message.status.finished");
            }
            case EXECUTION_ERROR: {
                if (exitCode != null) {
                    return this.getString("message.status.finished.error.code", exitCode);
                }
                return this.getString("message.status.finished.error");
            }
            case NO_EXIT_CODE: {
                return this.getString("message.status.finished.no_code");
            }
            case SUCCESS: {
                return this.getString("message.status.finished.success");
            }
            case FAILED: {
                return this.getString("message.status.finished.failed");
            }
            case KILLED: {
                return this.getString("message.status.finished.killed");
            }
            case LOST: {
                return this.getString("message.status.finished.lost");
            }
        }
        return this.getString("message.status.finished");
    }

    @Override
    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public void commandUpdated(CommandUpdatedEvent.Type type, CommandInfo cmd) {
        this.command = cmd;
        this.reload();
    }

    private void reload() {
        final boolean commandFinished = this.isCommandFinished();
        SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Collection<ReloadableTab> tabs = AbstractCommandView.this.reloadableTabs.values();
                    for (ReloadableTab tab : tabs) {
                        if (tab == null) continue;
                        if (tab instanceof AutoReloadable) {
                            if (!commandFinished) continue;
                            LogPanelReloader reloader = ((AutoReloadable)((Object)tab)).getReloader();
                            reloader.stop();
                            continue;
                        }
                        tab.reload();
                    }
                    AbstractCommandView.this.updateStatusBar();
                }
                catch (Exception e) {
                    AbstractCommandView.this.statusBar.setError(AbstractCommandView.this.getString("error.loading.logs", new Object[]{AbstractCommandView.this.command.getId()}));
                }
            }
        });
    }

    protected boolean isCommandFinished() {
        return this.command.getStatus().equals((Object)CommandStatus.FINISHED);
    }

    @Override
    public void selectTab(AbstractTab.TabType tabType) throws ClientException {
        if (tabType != null) {
            Tab tab = null;
            switch (tabType) {
                case STATIC: {
                    if (this.staticTabs.isEmpty()) break;
                    tab = this.getNextTab(this.staticTabs.values());
                    break;
                }
                case RELOADABLE: {
                    if (this.reloadableTabs.isEmpty()) break;
                    tab = this.getNextTab(this.reloadableTabs.values());
                }
            }
            if (tab != null) {
                this.tabbedPane.setSelectedComponent(tab.getMainComponent());
                this.updateSelection();
            } else {
                this.selectPreferredTab();
            }
            this.selectPreferredTab();
        }
    }

    @Override
    public void selectTab(String title) throws ClientException {
        if (title != null) {
            Tab tab = this.getTabByTitle(title);
            if (tab != null) {
                this.tabbedPane.setSelectedComponent(tab.getMainComponent());
                this.updateSelection();
            } else {
                this.selectPreferredTab();
            }
        } else {
            this.selectPreferredTab();
        }
    }

    @Override
    public void selectPreferredTab() throws ClientException {
        Tab tab = null;
        if (!this.staticTabs.isEmpty()) {
            tab = this.getNextTab(this.staticTabs.values());
        } else if (!this.reloadableTabs.isEmpty()) {
            tab = this.getNextTab(this.reloadableTabs.values());
        }
        if (tab != null) {
            this.tabbedPane.setSelectedComponent(tab.getMainComponent());
            this.updateSelection();
        }
    }

    private Tab getNextTab(Collection<? extends Tab> collection) {
        Tab chosenTab = null;
        for (Tab tab : collection) {
            if (tab == null) continue;
            chosenTab = tab;
            break;
        }
        return chosenTab;
    }

    private Tab getTabByTitle(String title) {
        Tab tab = this.staticTabs.get(title);
        if (tab == null) {
            tab = this.reloadableTabs.get(title);
        }
        return tab;
    }

    @Override
    public Tab getSelected() {
        return this.selected;
    }

    @Override
    public void close() {
        if (this.selected != null) {
            this.selected.setSelected(false);
        }
        this.statusBar.shutdownTimer();
    }
}

