/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.facilities.algorithms.executor;

import csbase.client.desktop.RemoteTask;
import csbase.client.facilities.algorithms.parameters.NodeParametersValues;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.ParseException;
import csbase.exception.algorithms.ParameterNotFoundException;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public class CommandConfiguration {
    private String algorithmName;
    private AlgorithmVersionId algoVersionId;
    private Window owner;
    private AlgorithmConfigurator configurator;

    public CommandConfiguration(String algorithmName, AlgorithmVersionId algoVersionId, Window owner) {
        this.algorithmName = algorithmName;
        this.algoVersionId = algoVersionId;
        this.owner = owner;
    }

    public CommandConfiguration(AlgorithmConfigurator configurator, Window owner) {
        this.configurator = configurator;
        this.algorithmName = configurator.getAlgorithmName();
        this.algoVersionId = configurator.getAlgorithmVersionId();
        this.owner = owner;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public AlgorithmVersionId getAlgoVersionId() {
        return this.algoVersionId;
    }

    public Window getOwner() {
        return this.owner;
    }

    public boolean config(NodeParametersValues paramValues) {
        if (this.getConfigurator() == null) {
            return false;
        }
        try {
            Map<String, String> allParametersValues = paramValues.getAllParametersValues();
            this.configurator.setParameterValuesByName(allParametersValues);
        }
        catch (ParseException pe) {
            String msgTag = "ConfigAlgorithmAction.msg.error.invalid.params";
            String msg = LNG.get((String)"ConfigAlgorithmAction.msg.error.invalid.params");
            StandardErrorDialogs.showErrorDialog(this.owner, msg, (Throwable)pe);
            return false;
        }
        catch (ParameterNotFoundException e) {
            String msgTag = "ConfigAlgorithmAction.msg.error.invalid.params";
            String msg = LNG.get((String)"ConfigAlgorithmAction.msg.error.invalid.params");
            StandardErrorDialogs.showErrorDialog(this.owner, msg, (Throwable)e);
            return false;
        }
        return true;
    }

    public AlgorithmConfigurator getConfigurator() {
        RemoteTask<AlgorithmConfigurator> configuratorTask;
        boolean success;
        if (this.configurator == null && (success = (configuratorTask = new RemoteTask<AlgorithmConfigurator>(){

            protected void performTask() throws Exception {
                if (CommandConfiguration.this.algoVersionId == null) {
                    CommandConfiguration.this.algoVersionId = ClientRemoteLocator.algorithmService.getInfo(CommandConfiguration.this.algorithmName).getLastVersion().getId();
                }
                this.setResult(ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(CommandConfiguration.this.algorithmName, CommandConfiguration.this.algoVersionId));
            }
        }).execute(this.owner, this.owner.getName(), LNG.get((String)"ConfigAlgorithmAction.info.get.configurator")))) {
            this.configurator = (AlgorithmConfigurator)configuratorTask.getResult();
        }
        return this.configurator;
    }

    public Map<Object, Object> getExportedValues() {
        return this.configurator.exportValues();
    }
}

