package csbase.client.applications.filetransferclient.panels.remotepanel;

import java.util.List;

import javax.swing.table.AbstractTableModel;

import csbase.logic.filetransferservice.FileTransferElement;

/**
 * @author Tecgraf/PUC-Rio
 */
class RemoteTableModel extends AbstractTableModel {

  /**
   * Lista de arquivos
   */
  private List<FileTransferElement> fileList;

  /**
   * Aplicao (usada apnes para internacionalizao.
   */
  final private String[] columnNames;

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getRowCount() {
    if (fileList == null) {
      return 0;
    }
    return fileList.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int col) {
    if (col == 0) {
      return FileTransferElement.class;
    }
    else if (col == 1) {
      return String.class;
    }
    else if (col == 2) {
      return Long.class;
    }
    return null;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getColumnCount() {
    return columnNames.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getColumnName(final int col) {
    return columnNames[col];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public Object getValueAt(final int row, final int col) {
    final FileTransferElement file = fileList.get(row);
    if (col == 0) {
      return file;
    }
    else if (col == 1) {
      return file.getName();
    }
    else if (col == 2) {
      if (file.isDirectory()) {
        return -1L;
      }
      return file.getSizeBytes();
    }
    return null;
  }

  /**
   * Ajuste da lista de arquivos.
   * 
   * @param list a lista
   */
  final public void setFileList(final List<FileTransferElement> list) {
    fileList = list;
    fireTableDataChanged();
  }

  /**
   * @return a lista
   */
  final public List<FileTransferElement> getFileList() {
    return fileList;
  }

  /**
   * @param columnNames nomes das colunas.
   */
  public RemoteTableModel(final String[] columnNames) {
    this.columnNames = columnNames;
  }

}
