/**
 * $Id: TextRenderer.java 140813 2013-05-10 15:15:06Z fpina $
 */

package csbase.client.applications.serverdiagnostic.monitor;

import csbase.logic.diagnosticservice.Status;

/**
 * Interface de renderer que exibe as informaes de um
 * {@link Status} como texto.
 * 
 * @author Tecgraf
 */
public interface TextRenderer {

  /**
   * Obtm as informaes bsicas de um estado.
   * 
   * @param status o estado
   * 
   * @return as informaes bsicas
   */
  public String getHeadline(Status status);

  /**
   * Obtm as informaes detalhadas do estado do recurso.
   * 
   * @param status o estado
   * 
   * @return as informaes detalhadas
   */
  public String getDetails(Status status);
}
