package csbase.client.util.table;

import java.awt.Color;

import javax.swing.JComponent;

/**
 * Viso da Clula: a viso da clula da {@link Table Tabela}.
 */
public interface CellView {
  /**
   * Verifica se est no modo de edio.
   * 
   * @return .
   */
  public boolean isEditing();

  /**
   * Adiciona um observador de vises de clulas.
   * 
   * @param listener O observador (No aceita {@code null}).
   */
  void addCellViewListener(CellViewListener listener); 
  
  /**
   * Obtm a dica.
   * 
   * @return A dica ou {@code null} se no houver dica.
   */
  String getTip();
  
  /**
   * Obtm o valor armazenado na clula.
   * 
   * @return O valor ou {@code null} se no houver valor.
   */
  Object getValue();

  /**
   * Obtm a viso que representa a clula.
   * 
   * @return A viso.
   */
  JComponent getView();

  /**
   * Remove um observador de vises de clulas.
   * 
   * @param listener O observador (No aceita {@code null}).
   * 
   * @return {@code true} em caso de sucesso ou {@code false} se no existia tal
   *         observador cadastrado.
   */
  boolean removeCellViewListener(CellViewListener listener);

  /**
   * Modifica a cor de fundo.
   * 
   * @param backgroundColor A cor de fundo (No aceita {@code null}).
   */
  void setBackgroundColor(Color backgroundColor);

  /**
   * Altera o estado do foco desta viso de clula.
   * 
   * @param hasFocus .
   */
  void setFocus(boolean hasFocus);

  /**
   * Modifica a cor da letra.
   * 
   * @param foregroundColor A cor da letra (No aceita {@code null}).
   */
  void setForegroundColor(Color foregroundColor);

  /**
   * Modifica o valor armazenado na clula.
   * 
   * @param value O valor (Aceita {@code null}).
   * 
   * @return {@code true} se houve mudana no estado do objeto ou {@code false}
   *         o valor informando  igual ao valor anterior.
   */
  boolean setValue(Object value);

  /**
   * Prepara a viso comeando a edio.
   */
  void startEditing();

  /**
   * Prepara a viso terminando a edio.
   */
  void stopEditing();

  /**
   * Valida o valor corrente.
   * 
   * @return {@code true} vlida ou {@code false} invlida.
   */
  boolean validate();
}
