package csbase.client.util.table;

import java.util.LinkedList;
import java.util.List;

/**
 * Fbria de {@link ComboBoxCellView Clulas de ComboBoxes}: cria clulas de
 * <i>comboboxes</i>.
 */
public final class ComboBoxCellViewFactory implements CellViewFactory {

  /**
   * As vises criadas por esta fbrica.
   */
  private List<ComboBoxCellView> views;

  /**
   * Os tens disponveis para seleo.
   */
  private List<ComboBoxCellViewItem> availableItems;

  /**
   * Cria a fbrica.
   */
  public ComboBoxCellViewFactory() {
    views = new LinkedList<ComboBoxCellView>();
    availableItems = new LinkedList<ComboBoxCellViewItem>();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ComboBoxCellView create() {
    ComboBoxCellView view = new ComboBoxCellView(availableItems);
    views.add(view);
    return view;
  }

  /**
   * Atribui os tens disponveis para seleo nesta clula.
   * 
   * @param items Os tens disponveis (No aceita {@code null} e no pode estar
   *        vazio).
   * @return a prpria fbrica.
   */
  public ComboBoxCellViewFactory withItems(List<ComboBoxCellViewItem> items) {
    if (items == null) {
      throw new IllegalArgumentException("O parmetro items est nulo.");
    }
    availableItems.clear();
    availableItems.addAll(items);
    for (ComboBoxCellView view : views) {
      view.setAvailableItems(availableItems);
    }
    return this;
  }
}
