package csbase.client.applications.algorithmsmanager.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.TestDialog;
import csbase.client.applications.algorithmsmanager.report.implementations
  .AlgorithmManagerSubjectFactory;
import csbase.client.applications.algorithmsmanager.report.implementations
  .SimpleConfiguratorSource;
import csbase.client.applications.algorithmsmanager.report.implementations
  .TestConfiguratorInvalid;
import csbase.client.applications.algorithmsmanager.report.implementations
  .TestEmptyAlgorithm;
import csbase.client.applications.algorithmsmanager.report.implementations
  .TestHelpMissing;
import csbase.client.applications.algorithmsmanager.report.implementations
  .TestMissingPlatform;
import csbase.client.applications.algorithmsmanager.report.implementations
  .TestOutdatedFlow;
import csbase.client.applications.algorithmsmanager.report.implementations
  .TestParameterUsage;
import csbase.logic.Platform;

/**
 * Ao que dispara todos os testes disponveis no sistema
 *
 * @author Tecgraf/PUC-Rio
 */
public class RunTestsAction extends AlgorithmsManagerAction {

  /**
   * Fbrica de elementos a serem testados.
   */
  private AlgorithmManagerSubjectFactory subjectFactory = null;

  /**
   * Construtor
   *
   * @param application a aplicao.
   */
  public RunTestsAction(AlgorithmsManager application) {
    super(application);
  }

  /**
   * Dispara o dilogo de testes {@inheritDoc}
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {

    List<ITest<?>> allTests = buildAllTests();
    subjectFactory = getSubjectFactory();

    ApplicationFrame frame = getApplication().getApplicationFrame();

    TestDialog selectionDialog =
      new TestDialog(allTests, subjectFactory, getApplication().getLocale(),
        frame);

    selectionDialog.setVisible(true);
  }

  /**
   * Obtm a fbrica de sources, se no existir, cria
   *
   * @return A fbrica da instncia
   */
  private AlgorithmManagerSubjectFactory getSubjectFactory() {
    if (subjectFactory == null) {
      subjectFactory = new AlgorithmManagerSubjectFactory(getApplication());
    }
    return subjectFactory;
  }

  /**
   * Retorna todos os testes existentes
   *
   * @return Lista com todos os testes
   * @throws Exception Erro se no conseguir pegar as plataformas
   */
  private List<ITest<?>> buildAllTests() throws Exception {
    Frame frame = getApplication().getApplicationFrame();

    List<ITest<?>> allTests = new ArrayList<>();

    allTests.add(new TestOutdatedFlow(frame));
    allTests.add(new TestMissingPlatform(Platform.getAllPlatforms(), frame));
    allTests.add(new TestConfiguratorInvalid(frame));
    allTests.add(new TestEmptyAlgorithm(frame));
    allTests.add(new TestHelpMissing(frame));
    allTests.add(
      new TestParameterUsage(new SimpleConfiguratorSource(getApplication()),
        frame));
    return allTests;
  }

  /**
   * Reinicia o source
   */
  public void updateToReload() {
    getSubjectFactory().reset();
  }
}
