/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.ClientLocalFile;
import csbase.client.algorithms.parameters.ComponentProperties;
import csbase.client.algorithms.parameters.ParameterView;
import csbase.client.algorithms.parameters.SimpleParameterView;
import csbase.client.applicationmanager.ApplicationException;
import csbase.client.applicationmanager.resourcehelpers.ApplicationUtils;
import csbase.client.applications.ApplicationImages;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.tasks.GetChildFromNameTask;
import csbase.client.project.tasks.GetFileTask;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.SGASet;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.URLParameter;
import csbase.logic.algorithms.parameters.URLProtocol;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public abstract class URLParameterView
extends SimpleParameterView<FileURLValue> {
    public URLParameterView(URLParameter parameter, ParameterView.Mode mode) {
        super(parameter, mode, new Object[0]);
        this.updateViewContents();
        this.updateCapabilityView();
        this.updateVisibilyView();
    }

    @Override
    public URLParameter getParameter() {
        return (URLParameter)super.getParameter();
    }

    @Override
    protected JComponent createConfigurationComponent(Object ... componentArgs) {
        return new FileConfigurationParameter();
    }

    @Override
    protected JComponent createReportComponent(Object ... componentArgs) {
        return new FileReportParameter();
    }

    protected abstract FileURLValue askForFile(URLProtocol var1, Object ... var2);

    @Override
    protected void setEnabled(boolean isEnabled) {
        this.getComponent().setEnabled(isEnabled);
    }

    @Override
    protected void updateVisibilyView() {
        boolean isVisible;
        boolean bl = isVisible = this.getParameter().isVisible() && !this.getParameter().hasLink() && this.getParameter().usesPipe() != FileParameterPipeAcceptance.ALWAYS;
        if (this.isVisible() != isVisible) {
            this.setVisible(isVisible);
            this.fireVisibilityWasChanged();
        }
    }

    @Override
    public boolean fillVerticalSpace() {
        return false;
    }

    @Override
    public void updateViewContents() {
        ((IFileParameterComponent)((Object)this.getComponent())).updateViewContents();
    }

    private class FileConfigurationParameter
    extends JPanel
    implements IFileParameterComponent {
        private JTextField textField;
        private JComboBox protocolCombo;
        private JComboBox sgaCombo;
        private JButton browseButton;

        FileConfigurationParameter() {
            super(new GridBagLayout());
            URLParameter parameter = URLParameterView.this.getParameter();
            EnumSet allowedProtocols = parameter.getAllowedProtocols();
            this.protocolCombo = new JComboBox();
            for (URLProtocol protocol : allowedProtocols) {
                this.protocolCombo.addItem(protocol);
            }
            this.protocolCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        URLProtocol item = (URLProtocol)e.getItem();
                        FileConfigurationParameter.this.protocolChanged(item);
                    }
                }
            });
            if (allowedProtocols.size() == 1) {
                this.protocolCombo.setVisible(false);
            }
            this.browseButton = GUIUtils.createImageButton((Icon)ApplicationImages.ICON_BROWSEFILE_16);
            ActionListener browseAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    URLProtocol protocol = (URLProtocol)FileConfigurationParameter.this.protocolCombo.getSelectedItem();
                    FileURLValue file = URLParameterView.this.askForFile(protocol, FileConfigurationParameter.this.getSGASelected());
                    if (file != null) {
                        URLParameterView.this.getParameter().setValue((Object)file);
                    }
                }
            };
            this.browseButton.addActionListener(browseAction);
            this.browseButton.setToolTipText(URLParameterView.this.getParameter().getDescription());
            this.textField = new JTextField();
            this.textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    FileConfigurationParameter.this.updateModel();
                }
            });
            this.textField.setToolTipText(URLParameterView.this.getParameter().getDescription());
            this.sgaCombo = new JComboBox();
            this.updateSGAModel();
            this.add((Component)this.protocolCombo, new GBC(0, 0));
            this.add((Component)this.sgaCombo, new GBC(1, 0));
            this.add((Component)this.textField, new GBC(2, 0).both().left(2).right(2));
            this.add((Component)this.browseButton, new GBC(3, 0));
            this.protocolChanged(parameter.getDefaultProtocol());
        }

        private void updateSGAModel() {
            if (this.sgaCombo != null && this.sgaCombo.isVisible()) {
                List<String> sgaList = this.getSGAList();
                Object[] sgas = sgaList.toArray();
                if (sgaList.isEmpty()) {
                    this.sgaCombo.setEnabled(false);
                    String noSGAMessage = LNG.get((String)(URLParameterView.class.getSimpleName() + ".no_sga"));
                    this.sgaCombo.setToolTipText(noSGAMessage);
                } else {
                    this.sgaCombo.setEnabled(true);
                    this.sgaCombo.setModel(new DefaultComboBoxModel<Object>(sgas));
                }
                this.browseButton.setEnabled(this.sgaCombo.isEnabled());
            }
        }

        private void protocolChanged(URLProtocol protocol) {
            this.textField.setText(null);
            switch (protocol) {
                case LOCAL: {
                    this.sgaCombo.setVisible(false);
                    this.browseButton.setIcon(ApplicationImages.ICON_BROWSELOCALFILE_16);
                    this.browseButton.setVisible(true);
                    this.browseButton.setEnabled(true);
                    this.textField.setEditable(true);
                    break;
                }
                case PROJECT: {
                    this.sgaCombo.setVisible(false);
                    this.browseButton.setIcon(ApplicationImages.ICON_BROWSEFILE_16);
                    this.browseButton.setVisible(true);
                    this.browseButton.setEnabled(true);
                    this.textField.setEditable(true);
                    break;
                }
                case SGA: {
                    this.sgaCombo.setVisible(true);
                    this.browseButton.setIcon(ApplicationImages.ICON_BROWSESGAFILE_16);
                    this.browseButton.setVisible(true);
                    this.browseButton.setEnabled(this.sgaCombo.isEnabled());
                    this.textField.setEditable(this.sgaCombo.isEnabled());
                    break;
                }
                default: {
                    this.sgaCombo.setVisible(false);
                    this.browseButton.setVisible(false);
                    this.browseButton.setEnabled(false);
                    this.textField.setEditable(true);
                }
            }
            this.updateSGAModel();
            this.updateModel();
        }

        @Override
        public void updateViewContents() {
            FileURLValue file = (FileURLValue)URLParameterView.this.getParameter().getValue();
            if (file == null) {
                this.textField.setText("");
            } else {
                if (this.protocolCombo != null) {
                    URLProtocol protocol = file.getProtocol();
                    this.protocolCombo.setSelectedItem(protocol);
                }
                if (this.sgaCombo != null) {
                    this.updateSGAModel();
                    String host = file.getHost();
                    if (host != null) {
                        this.sgaCombo.setSelectedItem(host);
                    }
                }
                this.textField.setText(file.toString());
            }
            this.updateModel();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.textField.setEnabled(isEnabled);
            this.browseButton.setEnabled(isEnabled);
            if (this.protocolCombo != null) {
                this.protocolCombo.setEnabled(isEnabled);
            }
            if (this.sgaCombo != null) {
                this.sgaCombo.setEnabled(isEnabled);
            }
        }

        private String getSGASelected() {
            return (String)this.sgaCombo.getSelectedItem();
        }

        private void updateModel() {
            String text = this.textField.getText();
            if (text.length() == 0) {
                URLParameterView.this.getParameter().setValue(null);
            } else {
                if (text.equals("/")) {
                    text = ".";
                }
                ClientLocalFile file = null;
                String host = null;
                URLProtocol protocol = (URLProtocol)this.protocolCombo.getSelectedItem();
                if (protocol == URLProtocol.PROJECT) {
                    ClientProjectFile rootProjectFile;
                    String[] path = FileUtils.splitPath((String)text, (String)"/");
                    CommonClientProject project = DesktopFrame.getInstance().getProject();
                    ClientProjectFile clientProjectFile = rootProjectFile = project.getRoot();
                    for (String component : path) {
                        if (clientProjectFile == null) break;
                        clientProjectFile = GetChildFromNameTask.runTask(clientProjectFile, component);
                    }
                    file = clientProjectFile;
                } else if (protocol == URLProtocol.LOCAL) {
                    file = new ClientLocalFile(new File(text));
                } else if (protocol == URLProtocol.SGA) {
                    host = this.getSGASelected();
                }
                String type = file != null ? file.getType() : (URLParameterView.this.getParameter().getMode() == FileParameterMode.DIRECTORY ? "DIRECTORY_TYPE" : "UNKNOWN");
                FileURLValue value = new FileURLValue(text, type, protocol, host);
                URLParameterView.this.getParameter().setValue((Object)value);
            }
        }

        private List<String> getSGAList() {
            Vector<String> sgaNames = SGAProxy.getAllSGANames();
            if (sgaNames == null) {
                return new ArrayList<String>();
            }
            ArrayList<String> sgaList = new ArrayList<String>();
            for (String name : sgaNames) {
                SGASet sgaSet = SGAProxy.getSGASet(name);
                if (!sgaSet.mayExecuteCommand()) continue;
                sgaList.add(name);
            }
            return sgaList;
        }
    }

    private class FileReportParameter
    extends JPanel
    implements IFileParameterComponent {
        private JTextField textField;

        FileReportParameter() {
            JButton button;
            this.setLayout(new GridBagLayout());
            this.textField = new JTextField();
            URLParameter parameter = URLParameterView.this.getParameter();
            this.textField.setToolTipText(parameter.getDescription());
            ComponentProperties.setProperties(this.textField, ParameterView.Mode.REPORT, true);
            this.textField.setEditable(false);
            this.add((Component)this.textField, new GBC(0, 0).horizontal());
            FileURLValue value = (FileURLValue)parameter.getValue();
            if (value != null && value.getProtocol() == URLProtocol.PROJECT && (button = this.createShowButton(this.textField)) != null) {
                this.add((Component)button, new GBC(1, 0));
            }
            this.updateViewContents();
        }

        private JButton createShowButton(JTextField field) {
            final FileURLValue value = (FileURLValue)URLParameterView.this.getParameter().getValue();
            if (value == null || !value.getType().equals("LOG")) {
                return null;
            }
            JButton browseButton = GUIUtils.createImageButton((Icon)ApplicationImages.ICON_VIEWLOG_16);
            browseButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    try {
                        ClientProjectFile file = FileReportParameter.this.getClientProjectFile(value);
                        ApplicationUtils.runPreferredApp(URLParameterView.this.getWindow(), file);
                    }
                    catch (ApplicationException e) {
                        DesktopFrame desktop = DesktopFrame.getInstance();
                        DesktopComponentFrame frame = desktop.getDesktopFrame();
                        StandardErrorDialogs.showErrorDialog((Window)frame, e);
                    }
                }
            });
            browseButton.setToolTipText(URLParameterView.this.getParameter().getDescription());
            return browseButton;
        }

        private ClientProjectFile getClientProjectFile(FileURLValue paramValue) {
            CommonClientProject project = DesktopFrame.getInstance().getProject();
            String[] path = paramValue.getPathAsArray();
            return GetFileTask.runTask(URLParameterView.this.getWindow(), project, path);
        }

        @Override
        public void updateViewContents() {
            FileURLValue value = (FileURLValue)URLParameterView.this.getParameter().getValue();
            String text = null;
            if (value != null) {
                URLProtocol selectedProtocol = value.getProtocol();
                text = selectedProtocol == FileURLValue.DEFAULT_PROTOCOL ? value.getPath() : selectedProtocol.getDisplayName() + value.getPath();
            }
            this.textField.setText(text);
        }
    }

    private static interface IFileParameterComponent {
        public void updateViewContents();
    }
}

