package csbase.client.algorithms;

import java.awt.event.ActionEvent;
import java.util.List;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.actions.FlowApplicationAction;
import csbase.client.preferences.PreferenceManager;
import csbase.client.preferences.types.PVList;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;

/**
 * Ao do menu que remove um algoritmo do grupo de algoritmos facoritos.
 *
 * @author Tecgraf/PUC-Rio
 */
public class AlgorithmFavoriteRemoveAction extends FlowApplicationAction {

  /**
   * A verso do algoritmo.
   */
  private AlgorithmInfo algorithmInfo;

  /**
   * Cria a ao.
   * 
   * @param application A aplicao construtura de fluxos.
   */
  public AlgorithmFavoriteRemoveAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_FAVORITE_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent e) {
    delAsFavoriteApplication(algorithmInfo);
    getApplication().reloadAlgorithmTree();
  }

  /**
   * Remove um algoritmo como favorito
   *
   * @param info O algoritmo a ser removido.
   */
  final public void delAsFavoriteApplication(AlgorithmInfo info) {
    final AlgorithmInfo algorithm = AlgorithmManagementProxy
      .getAlgorithmInfoById(info.getId(), null,
        AlgorithmManagementProxy.AlgorithmOperation.EXECUTE_ALGORITHM);

    if (algorithm == null) {
      return;
    }

    final List<String> ids = FlowApplication.getFavoriteAlgorithmsIds();
    if (!ids.contains(info.getId())) {
      return;
    }
    final PVList fav = FlowApplication.getFavorites();
    ids.remove(info.getId());
    fav.setValue(ids);
    PreferenceManager.getInstance().savePreferences();
  }

  /**
   * Associa um algoritmo a esta ao.
   *
   * @param algorithmInfo O algoritmo.
   */
  public void setAlgorithmInfo(AlgorithmInfo algorithmInfo) {
    this.algorithmInfo = algorithmInfo;
  }

}
