package csbase.client.algorithms.parameters;

import csbase.logic.algorithms.parameters.TableColumn;

/**
 * Classe abstrata que facilita a criao de {@link TableColumnView}.
 *
 * @param <V> O tipo do valor armazenado na coluna.
 * @param <C> O tipo da coluna.
 *
 * @author Tecgraf/PUC-Rio
 */
public abstract class AbstractTableColumnView<V, C extends TableColumn<V>>
  implements TableColumnView<V, C> {

  /**
   * A viso da tabela.
   */
  private TableParameterView tableView;

  /**
   * A coluna.
   */
  private C column;

  /**
   * Cria a viso.
   *
   * @param tableView A viso da tabela (No aceita {@code null}).
   * @param column A coluna (No aceita {@code null}).
   */
  protected AbstractTableColumnView(TableParameterView tableView, C column) {
    if (tableView == null) {
      throw new IllegalArgumentException("tableView == null");
    }
    this.tableView = tableView;
    if (column == null) {
      throw new IllegalArgumentException("column == null");
    }
    this.column = column;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final C getColumn() {
    return column;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final void showErrorMessage(String message) {
    tableView.showErrorMessage(message);
  }
}
