package csbase.client.applications.algorithmsmanager.report.implementations;

import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import csbase.client.applications.algorithmsmanager.report.core.AbstractTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.logic.FileInfo;
import csbase.logic.Platform;
import csbase.logic.algorithms.AlgorithmConfigurator.ConfiguratorType;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import tecgraf.javautils.core.lng.LNG;

/**
 * Teste que verifica se existem algoritmos sem os binrios das plataformas em
 * questo.
 * 
 *
 * @author Tecgraf/PUC-Rio
 */
public class TestMissingPlatform extends AbstractTest<AlgorithmInfo> {

  /** Lista de plataformas a serem testadas **/
  private final List<String> existingPlataforms;

  /**
   * Construtor
   * 
   * @param registeredPlatform Lista de plataformas cadastradas no sistema
   * @param window Janela que disparou o teste
   */
  public TestMissingPlatform(List<Platform> registeredPlatform, Window window) {
    super(window, LNG.get("TestMissingPlatform.task.title"), LNG.get(
      "TestMissingPlatform.task.message"));
    this.existingPlataforms = new ArrayList<>();
    for (Platform platform : registeredPlatform) {
      this.existingPlataforms.add(platform.getName());
    }
  }

  /** {@inheritDoc} */
  @Override
  public List<IResultMessage<AlgorithmInfo>> doTest(
    AlgorithmInfo algorithmInfo) {

    List<IResultMessage<AlgorithmInfo>> list = new ArrayList<>();

    for (AlgorithmVersionInfo version : algorithmInfo.getVersions()) {
      if (version.getType() == ConfiguratorType.SIMPLE) {

        List<String> missing = new ArrayList<>();
        List<String> extra = new ArrayList<>();

        Map<String, List<FileInfo>> platforms = version.getPlatforms();

        for (String platform : existingPlataforms) {
          List<FileInfo> exeInfo = platforms.get(platform);
          if (exeInfo == null || exeInfo.size() <= 0) {
            missing.add(platform);
          }
        }

        for (String platform : platforms.keySet()) {
          if (!existingPlataforms.contains(platform)) {
            extra.add(platform);
          }
        }

        String missingText = missing.toString();
        String extraText = extra.toString();

        IResultMessage<AlgorithmInfo> message = null;

        if (missing.size() == 0 && extra.size() == 0) {
          message = new ResultMessage<>(algorithmInfo, TestStatus.OK, LNG.get(
            "TestMissingPlatform.perfect.match", new String[] { version
              .toString() }));
        }
        else if (platforms.size() <= 0) {
          message = new ResultMessage<>(algorithmInfo, TestStatus.ERROR, LNG
            .get("TestMissingPlatform.missing.all", new String[] { version
              .toString() }));
        }

        else if (extra.size() > 0) {

          if (missing.size() == existingPlataforms.size()) {
            message = new ResultMessage<>(algorithmInfo, TestStatus.WARNING, LNG
              .get("TestMissingPlatform.missing.all.with.extras", new String[] {
                  version.toString(), extraText }));
          }
          else if (missing.size() < existingPlataforms.size() && missing
            .size() > 0) {
            message = new ResultMessage<>(algorithmInfo, TestStatus.WARNING, LNG
              .get("TestMissingPlatform.missing.and.extras", new String[] {
                  version.toString(), missingText, extraText }));
          }
          else if (missing.size() == 0) {
            message = new ResultMessage<>(algorithmInfo, TestStatus.WARNING, LNG
              .get("TestMissingPlatform.only.extras", new String[] { version
                .toString(), extraText }));
          }
        }

        if (message != null) {
          list.add(message);
        }
      }
    }

    return list;

  }

  /** {@inheritDoc} */
  @Override
  public String getName() {
    return LNG.get("TestMissingPlatform.name");
  }

  /** {@inheritDoc} */
  @Override
  public String getDescription() {
    return LNG.get("TestMissingPlatform.description");
  }

  /** {@inheritDoc} */
  @Override
  public Class<AlgorithmInfo> getSubjectClass() {
    return AlgorithmInfo.class;
  }

  /** {@inheritDoc} */
  @Override
  public String getSubjectName(AlgorithmInfo subject) {
    return subject.getName();
  }

}
