/*
 * $Id:$
 */

package csbase.client.applications.xmlviewer.actions;

import java.util.List;

import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.xmlviewer.XMLViewer;
import csbase.client.applications.xmlviewer.actions.core.XMLViewerAbstractOpenAction;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;
import csbase.exception.PermissionException;

/**
 * Ao de carregar um relatrio da rea de local.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class XMLViewerLocalOpenAction extends XMLViewerAbstractOpenAction {

  /**
   * ltimo diretrio local aberto para relatrios.
   */
  private ClientLocalFile lastDirectory = null;

  /**
   * Construtor
   * 
   * @param application aplicao.
   */
  public XMLViewerLocalOpenAction(XMLViewer application) {
    super(application, ApplicationImages.ICON_OPEN_LOCAL_16);
  }

  /**
   * Mtodo inteno de busca de arquivo.
   * 
   * @return um objeto <code>ClientProjectFile</code> ou <code>null</code>.
   */
  @Override
  final protected ClientLocalFile getFileForOpen() {
    final XMLViewer application = getApplication();
    final ApplicationFrame window = application.getApplicationFrame();
    final List<String> fileCodes = application.getFileTypes();
    final String title = application.getName();
    final ClientLocalFile clientLocalFile =
      ClientLocalFileChooserUtil.browseSingleFileInOpenMode(window, fileCodes,
        title, true, lastDirectory);
    if (clientLocalFile == null) {
      return null;
    }

    if (!clientLocalFile.exists()) {
      final String err =
        getString("XMLViewerLocalOpenAction.file.not.found.error");
      StandardDialogs.showErrorDialog(window, title, err);
      return null;
    }

    try {
      lastDirectory = clientLocalFile.getParent();
    }
    catch (PermissionException pe) {
      // Nada a fazer: o ltimo diretrio no pode ser armazenado.
    }

    return clientLocalFile;
  }

}
