package csbase.client.applications.flowapplication.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import csbase.client.ClientLocalFile;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.util.filechooser.ClientLocalFileChooserUtil;

/**
 * Ao salvar grafo local.
 */
public final class SaveAsLocalAction extends FlowApplicationAction {
  /**
   * Cria a ao.
   *
   * @param application A aplicao.
   */
  public SaveAsLocalAction(FlowApplication application) {
    super(application, ApplicationImages.ICON_SAVEAS_LOCAL_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void handleActionPerformed(ActionEvent ev) {
    final FlowApplication app = getApplication();
    final String defType = app.getDefaultFileType();
    final ApplicationFrame window = app.getApplicationFrame();
    final List<String> fileTypes = new ArrayList<>();
    fileTypes.add(defType);
    ClientLocalFile file = ClientLocalFileChooserUtil
      .browseSingleFileInSaveMode(window, fileTypes, defType, app.getName(),
        false, (ClientLocalFile) null);
    app.saveAsGraph(file);
  }
}
