package csbase.client.applications.flowapplication.graph;

import java.net.URI;
import java.net.URL;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.app.beans.SVGIcon;

/**
 * Clase esttica que possui todos os cones utilizados na decorao de ns do
 * fluxo.  responsvel pela montagem de uma imagem do resource de uma aplicao
 * com base na biblioteca localizada em
 * <code>"/csbase/client/resources/svg/"</code>.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class GraphImages {

  /**
   * Diretrio das imagens de comando
   */
  private static final String COMMAND_ICON_DIR =
    "/csbase/client/resources/svg/";

  /**
   * Imagem para representar um algoritmo terminado em erro.
   */
  public static final SVGIcon ICON_ERROR = createSVGImage("error");

  /**
   * Imagem para representar um algoritmo terminado em erro fatal (responsvel
   * pelo fim da execuo).
   */
  public static final SVGIcon ICON_FATAL_ERROR = createSVGImage("fatal_error");
  /**
   * Imagem para representar um algoritmo terminado em erro no-fatal (no foi
   * responsvel pelo fim da execuo).
   */
  public static final SVGIcon ICON_NON_FATAL_ERROR =
    createSVGImage("non_fatal_error");
  /**
   * Imagem para representar um algoritmo que no apresenta cdigo de sada
   * porque foi terminado devido a erro de outro algoritmo.
   */
  public static final SVGIcon ICON_INTERRUPTED = createSVGImage("interrupted");

  /**
   * Imagem para representar um algoritmo terminado com sucesso.
   */
  public static final SVGIcon ICON_SUCCESS = createSVGImage("ok");

  /**
   * Imagem para representar um algoritmo que no apresenta cdigo de sada, mas
   * deveria.
   */
  public static final SVGIcon ICON_NO_CODE = createSVGImage("no_code");

  /**
   * Imagem para representar um algoritmo em execuo.
   */
  public static final SVGIcon ICON_EXECUTING = createSVGImage("executing");

  /**
   * Imagem para representar um algoritmo na fila do escalonador.
   */
  public static final SVGIcon ICON_SCHEDULED = createSVGImage("scheduled");

  /**
   * Imagem para representar o um algoritmo com alertas de execuo.
   */
  public static final SVGIcon ICON_WARNING = createSVGImage("warning");

  /**
   * Imagem para representar um algoritmo com falha de seus dados de
   * persistncia.
   */
  public static final SVGIcon ICON_SYSTEM_FAILURE =
    createSVGImage("system_failure");

  /**
   * Imagem para representar o um algoritmo desatualizado.
   */
  public static final SVGIcon ICON_OUTDATED = createSVGImage("outdated");

  /**
   * Extenso padro dos arquivos (formato) das imagens.
   */
  private static final String DEFAULT_IMAGE_EXTENSION = "svg";

  /**
   * Imagem para representar o um algoritmo inexistente.
   */
  public static final SVGIcon ICON_MISSING = createSVGImage("missing");

  /**
   * Cria a imagem a partir do nome do arquivo.
   * 
   * @param name nome do arquivo de imagem.
   * 
   * @return a imagem
   */
  protected static SVGIcon createSVGImage(final String name) {
    return createSVGImage(name, COMMAND_ICON_DIR, DEFAULT_IMAGE_EXTENSION);
  }

  /**
   * Cria a imagem a partir das informaes de nome, diretrio e extenso.
   * 
   * @param imageIconName nome do arquivo de imagem.
   * @param imageDir Caminho do diretrio das imagens
   * @param imageExtension Extenso do arquivo de imagem
   * @return a imagem
   */
  protected static SVGIcon createSVGImage(final String imageIconName,
    final String imageDir, final String imageExtension) {
    final String fullName = imageIconName + "." + imageExtension;
    final String resPath = imageDir + fullName;
    final URL res = GraphImages.class.getResource(resPath);
    if (res == null) {
      System.err.println("No foi possvel criar a imagem SVG.\n" + "nome:"
        + fullName + " no diretrio: " + imageDir);
      return null;
    }

    final SVGIcon icon = new SVGIcon();
    final URI uri = SVGCache.getSVGUniverse().loadSVG(res);
    icon.setSvgURI(uri);
    return icon;
  }

}
