package csbase.client.csdk.v1_0;

import java.util.HashMap;
import java.util.Map;

import csbase.client.applicationmanager.ApplicationException;
import csbase.client.csdk.v1_0.application.CSDKApplicationContext;
import csbase.client.csdk.v1_0.command.CSDKCommandContext;
import csbase.client.csdk.v1_0.eventlog.EventLogContext;
import csbase.client.csdk.v1_0.extras.user.CSDKUserContext;
import csbase.client.csdk.v1_0.filesystem.CSDKLocalFileSystemContext;
import csbase.client.csdk.v1_0.filesystem.CSDKProjectContext;
import csbase.client.csdk.v1_0.openbus.OpenBusContext;
import csbase.logic.applicationservice.ApplicationRegistry;
import csdk.v1_0.api.application.IApplicationContext;
import csdk.v1_0.api.command.ICommandContext;
import csdk.v1_0.api.core.IContext;
import csdk.v1_0.api.filesystem.local.ILocalFileSystemContext;
import csdk.v1_0.api.filesystem.project.IProjectContext;
import csdk.v1_0.api.user.IUserContext;
import csdk.v1_0.extras.context.IEventLogContext;
import csdk.v1_0.extras.context.IOpenBusContext;

/**
 * Interface para fbricas de contextos do CSDK 1.0
 */
public class CSDKContextFactory {

  /**
   * Cria o mapa de contextos do CSDK, que sero disponibilizados para a
   * aplicao especificada atravs do ambiente CSDK
   * {@link csdk.v1_0.api.core.ICSDKEnvironment#getContext(Class)}, indexados
   * pelas interfaces CSDK
   * que eles implementam.
   *
   * @param instanceId identificador da instncia da aplicao.
   * @param mainClass classe principal da aplicao.
   * @param registry o registro da aplicao.
   * @return o mapa de contextos.
   * @throws ApplicationException em caso de erro ao criar os contextos.
   */
  public static Map<Class<? extends IContext>, IContext> createCSDKContexts(
    String instanceId,
    Class<? extends csdk.v1_0.api.application.IApplication> mainClass,
    ApplicationRegistry registry) throws ApplicationException {
    Map<Class<? extends IContext>, IContext> contexts = new HashMap<>();
    contexts.put(IApplicationContext.class,
      new CSDKApplicationContext(instanceId, mainClass, registry));
    contexts.put(IProjectContext.class, new CSDKProjectContext(registry));
    contexts.put(ILocalFileSystemContext.class,
      new CSDKLocalFileSystemContext(registry));
    contexts.put(ICommandContext.class, new CSDKCommandContext());
    contexts.put(IOpenBusContext.class, new OpenBusContext());
    contexts.put(IUserContext.class, new CSDKUserContext());
    contexts.put(IEventLogContext.class, new EventLogContext());
    return contexts;
  }
}
