/*
 * $Id$
 */

package csbase.client.applications.algorithmsmanager.versiontree;

import java.awt.datatransfer.DataFlavor;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import csbase.client.applications.algorithmsmanager.versiontree.actions.CommonAlgoFileRenameAction;
import csbase.client.applications.algorithmsmanager.versiontree.actions.CopyFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.EditConfigurationFileAction;
import csbase.client.applications.algorithmsmanager.versiontree.actions.ExportConfigurationFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.PasteFile;
import csbase.client.applications.algorithmsmanager.versiontree.actions.RemoveConfigurationFiles;
import csbase.client.applications.algorithmsmanager.versiontree.actions.VersionWarningActionDecorator;
import csbase.logic.ClientAlgorithmFile;
import csbase.logic.ClientAlgorithmFile.AlgorithmFileType;
import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.ConfigurationPathFactory;
import tecgraf.javautils.core.lng.LNG;

/**
 * @author Tecgraf / PUC-Rio
 *
 *         N que representa arquivos de configurao.
 */
public final class ConfigurationFileNode extends AbstractFileInfoNode {

  /**
   * Descreve o formato de objeto que pode ser transferido pelas operaes de
   * transferncia (drag&amp;drop ou clipboard) na rvore.
   */
  public static final DataFlavor DATA_FLAVOR = new DataFlavor(
    ConfigurationFileNode.class, ConfigurationFileNode.class.getSimpleName());

  /**
   * Construtor.
   *
   * @param tree rvore que detm este n.
   * @param version Verso que detm o arquivo representado por este n.
   * @param file Arquivo representado por este n.
   */
  protected ConfigurationFileNode(final VersionTree tree,
    final AlgorithmVersionInfo version, final FileInfo file) {
    super(tree, version, file, file1 -> new ConfigurationFileNode(tree, version,
      file1), false);
  }

  /**
   * Cria um menu pop-up para este n.
   *
   * @return um menu pop-up para este n.
   */
  @Override
  public JPopupMenu createPopupMenu() {
    JPopupMenu popupMenu = new JPopupMenu();
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(new CopyFile(
      getTree(), LNG.get("algomanager.menu.config.copy")))));
    if (getFile().isDirectory()) {
      popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
        new PasteFile(getTree(), LNG.get("algomanager.menu.config.paste"),
          ConfigurationFileNode.DATA_FLAVOR))));
      popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
        new CommonAlgoFileRenameAction(getTree()))));
    }
    else {
      if (getTree().getSelectionCount() == 1) {
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
          new EditConfigurationFileAction(getTree(), getVersion(),
            getFile()))));
        popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
          new CommonAlgoFileRenameAction(getTree()))));
      }
    }
    popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
      new RemoveConfigurationFiles(getTree(), getVersion(),
        getSelectedFiles()))));
    if (!getFile().isDirectory()) {
      popupMenu.add(new JMenuItem(new VersionWarningActionDecorator(
        new ExportConfigurationFile(getTree(), getVersion(), getFile()))));
    }

    return popupMenu;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public DataFlavor getDataFlavor() {
    return DATA_FLAVOR;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final IPathFactory createSourcePathFactory(DataTransferObject dto) {
    AlgorithmVersionInfo sourceVersion = dto.getVersion();
    return new ConfigurationPathFactory(sourceVersion);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected final IPathFactory createTargetPathFactory() {
    return new ConfigurationPathFactory(getVersion());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public AlgorithmFileType getType() {
    return ClientAlgorithmFile.AlgorithmFileType.CONFIGURATION;
  }
}
