package csbase.client.applications.projectsmanager.proxy;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectSpecificAreaOccupationData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.User;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.DiskUsageServiceInterface;

/**
 * Task que obtm informaes especficas sobre a ocupao da rea de projetos
 * por usurio.
 * 
 * @author jnlopes
 */
public class GetSpecificSpaceUsageTask extends
  ProjectsManagerTask<ProjectSpecificAreaOccupationData> {

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   */
  public GetSpecificSpaceUsageTask(final ProjectsManager projectsManager) {
    super(projectsManager);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {

    final DiskUsageServiceInterface dsi = ClientRemoteLocator.diskUsageService;
    final Hashtable<Object, Double> occupiedSpaceByUsersHT = dsi.getUsersList();

    if (occupiedSpaceByUsersHT == null) {
      setResult(null);
      return;
    }

    final User[] users = new User[occupiedSpaceByUsersHT.size()];
    final Double[] spaces = new Double[occupiedSpaceByUsersHT.size()];

    final Iterator<Map.Entry<Object, Double>> iter =
      occupiedSpaceByUsersHT.entrySet().iterator();

    int counter = 0;
    while (iter.hasNext()) {
      final Map.Entry<Object, Double> me = iter.next();

      final User u = User.getUser(me.getKey());
      users[counter] = u;

      final Double s = me.getValue();
      spaces[counter] = s;

      counter++;
    }

    final ProjectSpecificAreaOccupationData psaod =
      new ProjectSpecificAreaOccupationData(users, spaces);

    setResult(psaod);
  }
}
