/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.commands.view;

import csbase.client.algorithms.commands.view.AbstractConsolidatedLogTab;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommandInfo;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ConsolidatedLogsTab
extends AbstractConsolidatedLogTab {
    private String title;
    private SortedSet<ClientProjectFile> files;

    public ConsolidatedLogsTab(CommandInfo commandInfo, Set<ClientProjectFile> files, String title) {
        super(commandInfo);
        this.files = new TreeSet<ClientProjectFile>(files);
        this.title = title;
    }

    @Override
    protected String getTitle() {
        return this.title;
    }

    @Override
    protected void loadLog() {
        this.textArea.setText("");
        try {
            String logsContent = this.readFiles(this.files);
            this.textArea.setText(logsContent);
        }
        catch (IOException e) {
            String errorTitle = LNG.get((String)"ConsolidatedLogsTab.error.title.loadFailed");
            String errorMsg = LNG.get((String)"ConsolidatedLogsTab.error.msg.loadFailed", (Object[])new Object[]{this.getCommand().getId()});
            StandardDialogs.showErrorDialog((Component)this.getParent(), (String)errorTitle, (String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFiles(Set<ClientProjectFile> files) throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        if (files != null) {
            for (ClientProjectFile file : files) {
                InputStream inputStream = null;
                BufferedReader bufferedReader = null;
                try {
                    printWriter.print("\n");
                    printWriter.printf("---- %s ----", file.getName());
                    if (file.exists()) {
                        printWriter.print("\n");
                        inputStream = file.getInputStream();
                        bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String line = bufferedReader.readLine();
                        while (line != null) {
                            printWriter.println(line);
                            line = bufferedReader.readLine();
                        }
                        continue;
                    }
                    String errorMsg = LNG.get((String)"ConsolidatedLogsTab.error.msg.fileNotFound");
                    printWriter.print(" [" + errorMsg + "]\n");
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                        continue;
                    }
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
        return writer.getBuffer().toString();
    }
}

