/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop.instancestoolbar;

import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.csdk.v2.application.CSDKApplication;
import csbase.client.desktop.instancestoolbar.ApplicationInstancesToolbar;
import csdk.v1_0.api.application.IApplication;
import csdk.v1_0.helper.AbstractCSDKWindowApplication;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationInstancesToolbarMouseAdapter
extends MouseAdapter {
    private final JComponent widget;
    private final Vector<ApplicationType> instances;

    private String getString(String key) {
        String className = this.getClass().getSimpleName();
        return LNG.get((String)(className + "." + key));
    }

    private void showMenuButton1() {
        JPopupMenu popmenu = new JPopupMenu();
        for (ApplicationType instance : this.instances) {
            JMenu menu = new JMenu();
            menu.setText(this.getApplicationInstanceLabel(instance));
            this.addWindowItems(menu, instance);
            menu.addSeparator();
            this.addInstanceItems(menu, instance);
            popmenu.add(menu);
        }
        popmenu.setVisible(true);
        popmenu.setVisible(false);
        popmenu.show(this.widget, 0, -popmenu.getHeight());
    }

    private String getApplicationInstanceLabel(ApplicationType instance) {
        String appName = instance.getName();
        String appIdx = "[" + instance.getInstanceIndex() + "]";
        String defaultName = appName + " - " + appIdx;
        if (!(instance instanceof Application)) {
            return defaultName;
        }
        Application app = (Application)instance;
        ApplicationFrame appFrame = app.getApplicationFrame();
        if (appFrame == null) {
            return defaultName;
        }
        String title = appFrame.getTitle();
        if (title == null) {
            return defaultName;
        }
        String text = title + " - " + appIdx;
        int max = 40;
        if (text.length() <= 40) {
            return text;
        }
        String prefix = text.substring(0, 20);
        String sufix = text.substring(20);
        return prefix + "..." + sufix;
    }

    private void addWindowItems(JMenu menu, ApplicationType instance) {
        AbstractCSDKWindowApplication csapp;
        IApplication iapp;
        ApplicationType app;
        JFrame frm = null;
        if (instance instanceof Application) {
            app = (Application)instance;
            frm = ((Application)app).getApplicationFrame();
        } else if (instance instanceof csbase.client.csdk.v1_0.application.CSDKApplication) {
            app = (csbase.client.csdk.v1_0.application.CSDKApplication)instance;
            iapp = ((csbase.client.csdk.v1_0.application.CSDKApplication)app).getApplication();
            if (iapp instanceof AbstractCSDKWindowApplication) {
                csapp = (AbstractCSDKWindowApplication)iapp;
                frm = csapp.getApplicationFrame();
            }
        } else if (instance instanceof CSDKApplication && (iapp = ((CSDKApplication)(app = (CSDKApplication)instance)).getApplication()) instanceof csdk.v2.helper.AbstractCSDKWindowApplication) {
            csapp = (csdk.v2.helper.AbstractCSDKWindowApplication)iapp;
            frm = csapp.getApplicationFrame();
        }
        if (frm == null) {
            return;
        }
        final ApplicationFrame frame = frm;
        JMenuItem hideItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                frame.setState(1);
            }
        });
        hideItem.setText(this.getString("hide.menu"));
        JMenuItem showItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                frame.setState(0);
                frame.toFront();
            }
        });
        showItem.setText(this.getString("show.menu"));
        JMenuItem frontItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                frame.toFront();
            }
        });
        frontItem.setText(this.getString("front.menu"));
        if ((frame.getState() & 1) != 0) {
            menu.add(showItem);
        } else {
            menu.add(frontItem);
            menu.add(hideItem);
        }
    }

    private void addInstanceItems(JMenu menu, final ApplicationType instance) {
        JMenuItem killItem = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                instance.closeApplication();
            }
        });
        killItem.setIcon(ApplicationImages.ICON_EXIT_16);
        killItem.setText(this.getString("kill.menu"));
        menu.add(killItem);
    }

    private void showMenuButton3() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem killAllItem = this.createKillAllItem();
        menu.add(killAllItem);
        menu.setVisible(true);
        menu.setVisible(false);
        menu.show(this.widget, 0, -menu.getHeight());
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        ApplicationInstancesToolbar.setWidgetBorder(this.widget, true);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        ApplicationInstancesToolbar.setWidgetBorder(this.widget, false);
    }

    private JMenuItem createKillAllItem() {
        final ArrayList<ApplicationType> toKill = new ArrayList<ApplicationType>(this.instances);
        JMenuItem item = new JMenuItem(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                toKill.forEach(ApplicationType::closeApplication);
            }
        });
        item.setText(this.getString("kill.all.item"));
        return item;
    }

    private void mouseTreated(MouseEvent e) {
        int button = e.getButton();
        if (button == 1) {
            this.showMenuButton1();
        } else if (button == 3) {
            this.showMenuButton3();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseTreated(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    protected ApplicationInstancesToolbarMouseAdapter(JComponent widget, Vector<ApplicationType> instances) {
        this.widget = widget;
        this.instances = instances;
    }
}

