/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias.server;

import csbase.client.desktop.RemoteTask;
import csbase.client.ias.ManagerPanel;
import csbase.client.ias.server.ServerInfoDialog;
import csbase.client.remote.manager.server.ServerInfoManager;
import csbase.client.remote.manager.server.ServerInfoManagerListener;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.server.ServerInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.rmi.RemoteException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.table.TableModel;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.DefaultObjectTableProvider;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public final class ServerInfoManagerPanel
extends ManagerPanel {
    private JFrame parent;
    private ObjectTableModel<ServerInfo> tableModel;
    private ServerInfoManagerListener managerListener;

    public ServerInfoManagerPanel(JFrame parent) {
        this.parent = parent;
        final String[] columnNames = new String[]{null, LNG.get((String)"IAS_SERVER_NAME"), LNG.get((String)"IAS_SERVER_URI"), LNG.get((String)"IAS_SERVER_SUSPENDED"), LNG.get((String)"IAS_SERVER_LOCAL"), LNG.get((String)"IAS_SERVER_COMPLETED")};
        final Class[] columnClasses = new Class[]{ServerInfo.class, String.class, String.class, String.class, String.class, String.class};
        if (ServerInfoManager.getInstance().isEnabled()) {
            DefaultObjectTableProvider provider = new DefaultObjectTableProvider(){

                public Object[] getCellValues(Object item) {
                    ServerInfo serverInfo = (ServerInfo)item;
                    String isSuspended = serverInfo.isSuspended() ? LNG.get((String)"IAS_YES") : LNG.get((String)"IAS_NO");
                    String isCompleted = serverInfo.isCompleted() ? LNG.get((String)"IAS_YES") : LNG.get((String)"IAS_NO");
                    String isLocal = serverInfo.isLocal() ? LNG.get((String)"IAS_YES") : LNG.get((String)"IAS_NO");
                    return new Object[]{serverInfo, serverInfo.getName(), serverInfo.getURI(), isSuspended, isLocal, isCompleted};
                }

                public String[] getColumnNames() {
                    return columnNames;
                }

                public Class<?>[] getColumnClasses() {
                    return columnClasses;
                }
            };
            this.tableModel = new ObjectTableModel(this.getServersInfos(), (ObjectTableProvider)provider);
            Comparator[] comparators = new Comparator[]{null, ClientUtilities.getStringComparatorIgnoreCase(), ClientUtilities.getStringComparatorIgnoreCase(), ClientUtilities.getStringComparatorIgnoreCase(), ClientUtilities.getStringComparatorIgnoreCase(), ClientUtilities.getStringComparatorIgnoreCase()};
            this.make((TableModel)this.tableModel, comparators, false);
            this.managerListener = new ServerInfoManagerListener(){

                @Override
                public void wasAddedServerInfo(final ServerInfo addedLocalServer) {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ServerInfoManagerPanel.this.tableModel.add((Object)addedLocalServer);
                            ServerInfoManagerPanel.this.getTable().adjustColumnWidth();
                        }
                    });
                }

                @Override
                public void wasRemovedServerInfo(final ServerInfo removedLocalServer) {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ServerInfoManagerPanel.this.tableModel.remove((Object)removedLocalServer);
                            ServerInfoManagerPanel.this.getTable().adjustColumnWidth();
                        }
                    });
                }

                @Override
                public void wasModifiedServerInfo(final ServerInfo oldLocalServer, final ServerInfo newLocalServer) {
                    SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ServerInfoManagerPanel.this.tableModel.remove((Object)oldLocalServer);
                            ServerInfoManagerPanel.this.tableModel.add((Object)newLocalServer);
                            ServerInfoManagerPanel.this.getTable().adjustColumnWidth();
                        }
                    });
                }
            };
            ServerInfoManager.getInstance().addServerInfoManagerListener(this.managerListener);
            this.getTable().adjustColumnWidth();
        } else {
            this.setLayout(new BorderLayout());
            JTextArea instructionsTextArea = new JTextArea(LNG.get((String)"IAS_SERVER_ADMIN_INSTRUCTIONS"));
            instructionsTextArea.setEditable(false);
            instructionsTextArea.setLineWrap(true);
            instructionsTextArea.setWrapStyleWord(true);
            this.add((Component)instructionsTextArea, "Center");
        }
    }

    @Override
    protected JPanel makeButtons() {
        JPanel panel = super.makeButtons();
        panel.add(new JPanel());
        this.createUpdateButton(panel);
        panel.add(new JPanel());
        JButton addButton = this.createAddCertButton(panel);
        JButton delButton = this.createRemCertButton(panel);
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{addButton, delButton});
        return panel;
    }

    private JButton createUpdateButton(JPanel panel) {
        JButton updateButton = new JButton(LNG.get((String)"IAS_SERVER_UPDATE"));
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerInfoManagerPanel.this.tableModel.setRows(ServerInfoManagerPanel.this.getServersInfos());
            }
        });
        panel.add(updateButton);
        return updateButton;
    }

    private JButton createAddCertButton(JPanel panel) {
        JButton addCertButton = new JButton(LNG.get((String)"IAS_SERVER_ADDCERT"));
        addCertButton.setEnabled(false);
        addCertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServerInfoManagerPanel.this.addCert();
                    ServerInfoManagerPanel.this.tableModel.setRows(ServerInfoManagerPanel.this.getServersInfos());
                }
                catch (CertificateParsingException cpe) {
                    StandardErrorDialogs.showErrorDialog((Window)ServerInfoManagerPanel.this.parent, LNG.get((String)"IAS_SERVER_ADDCERT_TITLE"), LNG.get((String)"IAS_SERVER_ADDCERT_PARSE_EXCEPTION_ERROR"));
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog(ServerInfoManagerPanel.this.parent, LNG.get((String)"IAS_SERVER_ADDCERT_TITLE"), LNG.get((String)"IAS_SERVER_ADDCERT_ERROR"), ex);
                }
            }
        });
        panel.add(addCertButton);
        this.addButtonToSelectionListener(addCertButton);
        return addCertButton;
    }

    private JButton createRemCertButton(JPanel panel) {
        JButton remCertButton = new JButton(LNG.get((String)"IAS_SERVER_REMCERT"));
        remCertButton.setEnabled(false);
        remCertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ServerInfoManagerPanel.this.remCert();
                    ServerInfoManagerPanel.this.tableModel.setRows(ServerInfoManagerPanel.this.getServersInfos());
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog(ServerInfoManagerPanel.this.parent, LNG.get((String)"IAS_SERVER_REMCERT_TITLE"), LNG.get((String)"IAS_SERVER_REMCERT_ERROR"), ex);
                }
            }
        });
        panel.add(remCertButton);
        this.addButtonToSelectionListener(remCertButton);
        return remCertButton;
    }

    private void remCert() throws Exception {
        int row = this.getTable().getSelectedRow();
        final ServerInfo serverInfo = (ServerInfo)this.getTable().getModel().getValueAt(row, 0);
        if (!serverInfo.isCompleted()) {
            return;
        }
        String msg = MessageFormat.format(LNG.get((String)"IAS_SERVER_REMCERT_CONFIRMATION_MESSAGE"), serverInfo.getName());
        int retVal = JOptionPane.showConfirmDialog(this.parent, msg, LNG.get((String)"IAS_SERVER_REMCERT_TITLE"), 0);
        if (retVal == 1) {
            return;
        }
        RemoteTask<Boolean> remCertTask = new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                ServerInfoManager.getInstance().removeCertificate(serverInfo.getName());
            }
        };
        if (!remCertTask.execute(this.parent, LNG.get((String)"IAS_SERVER_REMCERT_TITLE"), LNG.get((String)"IAS_SERVER_REMCERT_MESSAGE"))) {
            throw remCertTask.getError();
        }
    }

    private void addCert() throws Exception {
        int row = this.getTable().getSelectedRow();
        final ServerInfo serverInfo = (ServerInfo)this.getTable().getModel().getValueAt(row, 0);
        JFileChooser fileChooser = new JFileChooser();
        int retVal = fileChooser.showOpenDialog(this.parent);
        if (retVal == 0) {
            File certFile = fileChooser.getSelectedFile();
            FileInputStream certfis = new FileInputStream(certFile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            final Certificate cert = cf.generateCertificate(certfis);
            certfis.close();
            RemoteTask<Boolean> addCertTask = new RemoteTask<Boolean>(){

                protected void performTask() throws Exception {
                    ServerInfoManager.getInstance().addCertificate(serverInfo.getName(), cert);
                }
            };
            if (!addCertTask.execute(this.parent, LNG.get((String)"IAS_SERVER_ADDCERT_TITLE"), LNG.get((String)"IAS_SERVER_ADDCERT_MESSAGE"))) {
                throw addCertTask.getError();
            }
        }
    }

    @Override
    public void add() {
        new ServerInfoDialog(this.parent);
    }

    @Override
    public void modify(Object id) {
        ServerInfo localServer = (ServerInfo)id;
        if (localServer == null) {
            throw new IllegalStateException("N\u00e3o foi poss\u00edvel achar um servidor com o id " + id + ".");
        }
        new ServerInfoDialog(this.parent, localServer);
    }

    @Override
    public void delete(Object id) {
        final ServerInfo localServer = (ServerInfo)id;
        int option = StandardDialogs.showYesNoDialog((Component)this, (String)LNG.get((String)"IAS_SERVER_DELETE_TITLE"), (Object)MessageFormat.format(LNG.get((String)"IAS_SERVER_DELETE_CONFIRMATION_MESSAGE"), localServer.getName()));
        if (option == 0) {
            RemoteTask<Void> deleteLocalServerTask = new RemoteTask<Void>(){

                protected void performTask() throws Exception {
                    ServerInfoManager.getInstance().removeServerInfo(localServer);
                }
            };
            deleteLocalServerTask.execute(this.parent, LNG.get((String)"IAS_SERVER_DELETE_TITLE"), MessageFormat.format(LNG.get((String)"IAS_SERVER_DELETING_MESSAGE"), localServer.getName()));
        }
    }

    private List<ServerInfo> getServersInfos() {
        RemoteTask<SortedSet<ServerInfo>> getAllLocalServersTask = new RemoteTask<SortedSet<ServerInfo>>(){

            protected void performTask() throws RemoteException {
                this.setResult(ServerInfoManager.getInstance().getServersInfos());
            }
        };
        SortedSet localServerSortedSet = null;
        if (getAllLocalServersTask.execute(this.parent, LNG.get((String)"IAS_SERVER_GET_ALL_TITLE"), LNG.get((String)"IAS_SERVER_GETTING_ALL_MESSAGE"))) {
            localServerSortedSet = (SortedSet)getAllLocalServersTask.getResult();
        }
        if (localServerSortedSet == null) {
            return new LinkedList<ServerInfo>();
        }
        return new LinkedList<ServerInfo>(localServerSortedSet);
    }

    @Override
    public void beforeClose() {
        if (ServerInfoManager.getInstance().isEnabled()) {
            ServerInfoManager.getInstance().removeServerInfoManagerListener(this.managerListener);
        }
    }
}

