/*
 * $Id$
 */

package csbase.client.applicationmanager;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.List;

import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

/**
 * Internal frame de grupo de aplicao
 * 
 * @author Tecgraf/PUC-Rio
 */
class ApplicationGroupInternalFrame extends JInternalFrame {

  /**
   * Nome de propriedade:
   */
  private static final String WIDTH_INFO = "WIDTH_INFO";

  /**
   * Nome de propriedade:
   */
  private static final int DEFAULT_WIDTH = 300;

  /**
   * Nome de propriedade:
   */
  private static final String HEIGHT_INFO = "HEIGHT_INFO";

  /**
   * Nome de propriedade:
   */
  private static final int DEFAULT_HEIGHT = 400;

  /**
   * Nome de propriedade:
   */
  private static final String POS_X_INFO = "POS_X_INFO";

  /**
   * Nome de propriedade:
   */
  private static final int DEFAULT_POS_X = 0;

  /**
   * Nome de propriedade:
   */
  private static final String POS_Y_INFO = "POS_Y_INFO";

  /**
   * Nome de propriedade:
   */
  private static final int DEFAULT_POS_Y = 0;

  /**
   * Nome de propriedade:
   */
  private static final String SELECTED_INFO = "SELECTED_INFO";

  /**
   * Nome de propriedade:
   */
  private static final String ICON_INFO = "ICON_INFO";

  /**
   * Painel
   */
  private JPanel panel = null;

  /**
   * Retorna o painel.
   * 
   * @return o painel
   */
  public JPanel getPanel() {
    return this.panel;
  }

  /**
   * Atribui as configuracoes do frame
   * 
   * @param grpInfo o informativo do grupo
   */
  public void setInfo(Hashtable<String, Integer> grpInfo) {
    int width = Utilities
      .getIntegerFromHash(grpInfo, WIDTH_INFO, DEFAULT_WIDTH);
    int height = Utilities.getIntegerFromHash(grpInfo, HEIGHT_INFO,
      DEFAULT_HEIGHT);

    // Antes de dimensionar a janela, restaurar o seu tamanho
    if (this.isMaximum()) {
      try {
        this.setMaximum(false);
      }
      catch (PropertyVetoException e) {
      }
    }
    this.setSize(new Dimension(width, height));
    int x = Utilities.getIntegerFromHash(grpInfo, POS_X_INFO, DEFAULT_POS_X);
    int y = Utilities.getIntegerFromHash(grpInfo, POS_Y_INFO, DEFAULT_POS_Y);
    this.setLocation(x, y);
    this.panel.setPreferredSize(this.panel.getParent().getSize());

    /* O setSelected e o setIcon podem levantar excecao se o look and feel */
    /* nao prover suporte a iconificacao */
    try {
      boolean selected = Utilities.getBooleanFromHash(grpInfo, SELECTED_INFO,
        false);
      if (selected) {
        this.setSelected(true);
      }
      boolean icon = Utilities.getBooleanFromHash(grpInfo, ICON_INFO, false);
      this.setIcon(icon);
    }
    catch (PropertyVetoException e) {
    }
  }

  /**
   * Obtem as configuracoes do frame
   * 
   * @return as informaes como uma hash
   */
  public Hashtable<String, Object> getInfo() {
    Hashtable<String, Object> grpInfo = new Hashtable<String, Object>();
    grpInfo.put(WIDTH_INFO, new Integer(getWidth()));
    grpInfo.put(HEIGHT_INFO, new Integer(getHeight()));
    grpInfo.put(POS_X_INFO, new Integer(getX()));
    grpInfo.put(POS_Y_INFO, new Integer(getY()));
    grpInfo.put(ICON_INFO, new Boolean(isIcon()));
    grpInfo.put(SELECTED_INFO, new Boolean(isSelected()));
    return grpInfo;
  }

  /**
   * Fora o ajuste dos cones.
   */
  public void adjustIcons() {
    panel.setPreferredSize(this.panel.getParent().getSize());
    panel.setLayout(new FlowLayout());
  }

  /**
   * Consulta o retngulo utilizado pelos links do frame com base em seus limites e 
   * contando com o ponto (0,0) de forma a ajustar o tamanho desejvel do painel e
   * seu respectivo scrollpane. 
   * indicando que os elementos esto auto-ajustveis 
   * @return o retngulo de tamanho ou <code>null</code> se no existirem elementos.
   */
  private Rectangle getLinksBounds() {
    final Component[] cmps = panel.getComponents();
    if (cmps.length <= 0) {
      return null;
    }
    
    final Rectangle rect = new Rectangle();
    for (Component cmp : cmps) {
      rect.add(cmp.getBounds());
    }
    return rect;
  }

  /**
   * Ajuste do resize listener 
   */
  private void addResizeListener() {
    addComponentListener(new ComponentAdapter() {
      @Override
      public void componentResized(ComponentEvent e) {
        if (panel.getLayout() != null) {
          return;
        }
        resizePanelBasedOnLinks();
      }
    });
  }

  /**
   * Mtodo para controlar scrollpane (se necessrio) com base nas posies dos links.
   */
  private void resizePanelBasedOnLinks() {
    // O tamanho do painel (para controle da scrollbar) depende 
    // da rea ocupada pelos cones.
    final Rectangle rect = getLinksBounds();
    if (rect == null) {
      return;
    }
    panel.setPreferredSize(new Dimension(rect.width, rect.height));
  }

  /**
   * Construtor
   * @param title ttulo
   * @param icon icoce
   * @param links links
   */
  public ApplicationGroupInternalFrame(String title, Icon icon, List<ApplicationLink> links) {
    super(title, true, false, true, true);
    this.panel = new JPanel();
    JScrollPane scrollPane = new JScrollPane(this.panel);
    scrollPane.setSize(0, 0);
    getContentPane().add(scrollPane);
    
    setFrameIcon(icon);
    final JDesktopIcon dskIcon = new JDesktopIcon(this);
    setDesktopIcon(dskIcon);
    setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

    addResizeListener();
        
    setVisible(true);
    for (ApplicationLink link : links) {
      panel.add(link);
    }
  }
}
