package csbase.client.applications.commandsmonitor.events;

import csbase.client.util.event.IEvent;
import csbase.logic.CommandInfo;

/**
 * Evento lanado quando um comando  selecionado duas vezes pelo mouse, em um
 * perodo curto.
 * 
 * @author Tecgraf
 */
public class DoubleClickEvent implements IEvent {
  /**
   * Comando que recebeu o duplo clique do <i>mouse</i>.
   */
  private CommandInfo clicked;

  /**
   * Construtor.
   * 
   * @param clicked Comando que recebeu o duplo clique do <i>mouse</i>..
   */
  public DoubleClickEvent(CommandInfo clicked) {
    super();
    this.clicked = clicked;
  }

  /**
   * Obtm o comando que recebeu o duplo clique do <i>mouse</i>.
   * 
   * @return o comando que recebeu o duplo clique do <i>mouse</i>.
   */
  public CommandInfo getClicked() {
    return clicked;
  }
}
