/*
 * $Id:$
 */

package csbase.client.openbus;

import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;

/**
 * Task do OpenBus
 * 
 * @author Tecgraf/PUC-Rio
 * @param <R> tipode retorno.
 */
public abstract class OpenBusTask<R> extends RemoteTask<R> {

  /**
   * Busca texto de internacionalizao
   * 
   * @param key chave
   * @return texto.
   */
  protected String getString(final String key) {
    final String prefix = getClass().getSimpleName();
    return LNG.get(prefix + "." + key);
  }

  /**
   * Tratamento de erros especfico para cada tipo de tarefa. Esse tratamento 
   * chamado na thread do Swing. Pode ser redefinido por uma especializao
   * dessa classe, porm com cautela, para que a padronizao do tratamento de
   * erros no seja quebrada!
   * 
   * @param error exceo que representa erro durante execuo da tarefa
   */
  @Override
  protected void handleError(final Exception error) {
    final String[] additionalInfo = getAdditionalInfo();
    if (error instanceof NO_PERMISSION) {
      final String err = getString("no_permission");
      showError(additionalInfo, err);
    }
    else if (error instanceof SystemException) {
      final String err = getString("system_exception");
      showError(additionalInfo, err);
    }
    else {
      super.handleError(error);
    }
  }

  /**
   * Exibe mensagem de erro.
   * 
   * @param info infomaes
   * @param msg texto do erro.
   */
  private void showError(final String[] info, final String msg) {
    StandardErrorDialogs.showErrorDialog(parentWindow, taskTitle, msg, null,
      info);
  }

  /**
   * Construtor.
   */
  protected OpenBusTask() {
    /* nada a fazer */
  }
}
