/*
 * $Id$
 */
package csbase.client.project;

import java.awt.Font;

import javax.swing.JTextField;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.Utilities;

/**
 * Bara de localizao de seleo de projeto (rvore)
 * 
 * @author Tecgraf
 */
public class ProjectLocationBar extends JTextField {

  /**
   * A tree associada
   */
  final private ProjectTree projectTree;

  /**
   * Construtor
   * 
   * @param projectTree a tree associada
   */
  public ProjectLocationBar(final ProjectTree projectTree) {
    this.projectTree = projectTree;
    addProjectTreeListeners();
    this.setEditable(false);
    final Font font = getFont();
    final int style = font.getStyle();
    final int size = font.getSize();
    this.setFont(new Font(Font.MONOSPACED, style, size));
  }

  /**
   * Adiciona listeners na project tree
   */
  private void addProjectTreeListeners() {
    projectTree.addProjectTreeListener(new ProjectTreeAdapter() {
      @Override
      public void projectChanged(CommonClientProject proj) {
        String location = "";
        if (proj != null) {
          location = Utilities.makePath(proj.getRoot().getPath());
        }
        setText(location);
      }
    });

    projectTree.addTreeSelectionListener(new ProjectTreeSelectionListener() {
      @Override
      public void update(ProjectTreeSelectionEvent event) {
        ClientProjectFile[] selectedFiles = event.getSelectedFiles();
        final int numSelected = selectedFiles.length;
        if (numSelected == 1) {
          final ClientProjectFile selected = selectedFiles[0];
          final String pathText = Utilities.makePath(selected.getPath());
          setText(pathText);
        }
        else {
          String text = "";
          final int maxItens = 3;
          final int n = numSelected < maxItens ? numSelected : maxItens;
          for (int i = 0; i < n; i++) {
            final ClientProjectFile selected = selectedFiles[i];
            final String pathText = Utilities.makePath(selected.getPath());
            text = text + pathText + ", ";
          }
          if (numSelected > maxItens) {
            text = text + "...";
          }
          setText(text);
          setCaretPosition(0);
        }
      }
    });
  }
}
