package csbase.client.project.action;

import java.awt.event.ActionEvent;

import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;

/**
 * IMportao
 * 
 * @author Tecgraf/PUC-Rio
 */
public class CommonExchangeImportAction extends CommonExchangeAction {

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(ActionEvent ae) {
    final ClientProjectFile remoteDir = getSelectedRemoteFile();

    // Verifica se a aplicao j est executando.
    boolean isFileExchangerRunning = this.isFileExchangerRunning();

    final FileExchanger fileExchanger = getFileExchanger();
    final DesktopComponentFrame desktopFrame =
      DesktopFrame.getInstance().getDesktopFrame();
    if (fileExchanger == null) {
      showError(desktopFrame, getString("launch.error"));
      return;
    }

    try {
      fileExchanger.importToDirectory(remoteDir, new Boolean(
        isFileExchangerRunning));
    }
    catch (Exception e) {
      final DesktopFrame dsk = DesktopFrame.getInstance();
      StandardErrorDialogs.showErrorDialog(dsk.getDesktopFrame(), e);
    }
  }

  /**
   * Construtor
   * 
   * @param container o container de projetos
   * 
   */
  public CommonExchangeImportAction(ProjectFileContainer container) {
    super(container);
  }
}
