/**
 * $Id$
 */

package csbase.client.algorithms.parameters;

import java.awt.Window;
import java.text.MessageFormat;

import tecgraf.javautils.core.io.FileUtils;
import tecgraf.javautils.gui.StandardDialogs;
import csbase.client.desktop.DesktopFrame;
import csbase.client.kernel.ClientException;
import csbase.client.project.ProjectFileChooser;
import csbase.client.project.ProjectFileChooserSave;
import csbase.client.project.ProjectTreePath;
import csbase.logic.ClientProjectFile;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.FileURLValue;

/**
 * A Viso para {@link OutputFileParameter Parmetro do Tipo Arquivo de Sada}.
 *
 * @author lmoreira
 */
public final class OutputFileParameterView extends FileParameterView {

  /**
   * Cria uma viso em modo {@link ParameterView.Mode#CONFIGURATION}.
   *
   * @param window NO EST SENDO UTILIZADO. Existe somente para manter
   *        compatibilidade com o WebSintesi.
   * @param parameter O parmetro (No aceita {@code null}).
   *
   * @deprecated para manter compatibilidade com o WebSintesi
   */
  @Deprecated
  public OutputFileParameterView(Window window, OutputFileParameter parameter) {
    this(parameter, Mode.CONFIGURATION);
  }

  /**
   * Cria a viso.
   *
   * @param parameter O parmetro (No aceita {@code null}).
   * @param mode Modo de visualizao. No aceita {@code null}, os possveis
   *        valores so: {@link ParameterView.Mode#CONFIGURATION} ou
   *        {@link ParameterView.Mode#REPORT}.
   */
  public OutputFileParameterView(OutputFileParameter parameter, Mode mode) {
    super(parameter, mode);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public OutputFileParameter getParameter() {
    return (OutputFileParameter) super.getParameter();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected FileURLValue askForFile() {
    try {
      String[] fileTypes = getParameter().getFileTypes();
      String defaultType = null;
      if(fileTypes != null && fileTypes.length > 0) {
        defaultType = fileTypes[0];
      }
      ProjectFileChooserSave chooser =
        new ProjectFileChooserSave(getWindow(), DesktopFrame.getInstance()
          .getProject(), getFileChooserMode(), defaultType,
          null, null, getParameter().usesFilter());
      ProjectTreePath projectTreePath = chooser.getSelectedPath();
      if (projectTreePath == null) {
        return null;
      }
      ClientProjectFile clientProjectFile = projectTreePath.getFile();
      String type;
      if (clientProjectFile == null) {
        type = chooser.getFileType();
      }
      else {
        type = clientProjectFile.getType();
      }
      String path = FileUtils.joinPath('/', projectTreePath.getPath());
      return new FileURLValue(path, type);
    }
    catch (ClientException e) {
      String errorMessage =
        "Ocorreu um erro ao abrir o dilogo de seleo de arquivos.";
      if (e.getLocalizedMessage() != null) {
        errorMessage += "\nDetalhes:\n";
        errorMessage += e.getLocalizedMessage();
      }
      StandardDialogs.showErrorDialog(getWindow(),
        "Erro ao abrir o dilogo de seleo de arquivo", errorMessage);
      return null;
    }
  }

  /**
   * Obtm o modo do {@link ProjectFileChooser} que ser utilizado para
   * solicitar os arquivos ao usurio.
   * 
   * @return .
   */
  private int getFileChooserMode() {
    int mode;
    FileParameterMode parameterMode = getParameter().getMode();
    if (parameterMode.equals(FileParameterMode.REGULAR_FILE)) {
      mode = ProjectFileChooser.FILE_ONLY;
    }
    else if (parameterMode.equals(FileParameterMode.DIRECTORY)) {
      mode = ProjectFileChooser.DIRECTORY_ONLY;
    }
    else {
      String errorMessage =
        MessageFormat.format("O modo {0} no  vlido.", parameterMode);
      throw new IllegalStateException(errorMessage);
    }
    return mode;
  }
}
