/*
 * $Id$
 */

package csbase.client.applications.desktoplauncher.panels.eventpanel;

import java.util.ArrayList;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import csbase.client.applications.desktoplauncher.DesktopLauncherEvent;

/**
 * Modelo de arquivos locais.
 * 
 * @author Tecgraf/PUC-Rio
 */
class EventModel extends AbstractTableModel {

  /**
   * Lista de arquivos.
   */
  final private List<DesktopLauncherEvent> eventList =
    new ArrayList<DesktopLauncherEvent>();

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<?> getColumnClass(int col) {
    return DesktopLauncherEvent.class;
  }

  /**
   * Aplicao (usada apnes para internacionalizao.
   */
  final private String[] columnNames;

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getRowCount() {
    if (eventList == null) {
      return 0;
    }
    return eventList.size();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public int getColumnCount() {
    return columnNames.length;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public String getColumnName(final int col) {
    return columnNames[col];
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public Object getValueAt(final int row, final int col) {
    final DesktopLauncherEvent event = eventList.get(row);
    return event;
  }

  /**
   * @param columnNames nomes das colunas.
   */
  public EventModel(final String[] columnNames) {
    this.columnNames = columnNames;
  }

  /**
   * Adiciona evento.
   * 
   * @param ev evento
   */
  public void addLauncherEvent(DesktopLauncherEvent ev) {
    eventList.add(ev);
    fireTableDataChanged();
  }

  /**
   * Limpa a lista
   */
  public void clearLauncherEvents() {
    eventList.clear();
    fireTableDataChanged();
  }
}
