/*
 * $Id$
 */

package csbase.client.applications.filetransferclient.actions;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.dialogs.ConnectionFrame;

/**
 * Ao de conexo a um servidor (janela nica)
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ConnectionOnAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  final public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final ConnectionFrame frame = app.getSingleConnectionFrame();
    frame.start();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public ImageIcon getStandardImageIcon() {
    return null;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public ConnectionOnAction(FileTransferClient application) {
    super(application);
  }

}
