/*
 * $Id$
 */

package csbase.client.applications.filetransferclient.actions;

import java.util.List;

import javax.swing.ImageIcon;
import javax.swing.JComponent;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.filetransferclient.FileTransferClient;
import csbase.client.applications.filetransferclient.FileTransferClientUI;
import csbase.client.applications.filetransferclient.FileTransferProxy;
import csbase.client.applications.filetransferclient.actions.core.FileTransferClientAction;
import csbase.client.applications.filetransferclient.panels.localpanel.FileTransferClientLocalPanel;
import csbase.client.applications.filetransferclient.panels.queuepanel.FileTransferClientQueuePanel;
import csbase.client.applications.filetransferclient.panels.remotepanel.FileTransferClientRemotePanel;
import csbase.logic.ClientProjectFile;
import csbase.logic.filetransferservice.FileTransferConnection;

/**
 * @author Tecgraf/PUC-Rio
 */
public class UploadAction extends FileTransferClientAction {

  /**
   * {@inheritDoc}
   */
  @Override
  final public void actionDone(final JComponent component) {
    final FileTransferClient app = getApplication();
    final FileTransferClientRemotePanel remotePanel = app.getRemotePanel();
    final FileTransferClientLocalPanel localPanel = app.getLocalPanel();

    final List<ClientProjectFile> selFiles = localPanel.getSelectedFiles();

    if (selFiles == null || selFiles.size() <= 0) {
      return;
    }

    for (ClientProjectFile selFile : selFiles) {
      if (selFile == null) {
        continue;
      }
      if (selFile.isDirectory()) {
        continue;
      }

      String fileName = selFile.getName();

      final String remoteDir = remotePanel.getRemoteDirectory();
      final String remotePath = remoteDir + "/" + fileName;

      final ClientProjectFile localDirectory = localPanel.getLocalDirectory();
      final String localDir = FileTransferClientUI.pathToString(localDirectory);
      final String localPath;
      if (FileTransferClientUI.isEmptyString(localDir)) {
        localPath = fileName;
      }
      else {
        localPath = localDir + "/" + fileName;
      }

      String lPath = localPath;
      while (lPath.startsWith("/")) {
        lPath = lPath.substring(1);
      }
      final String[] localFilePath = lPath.split("/");

      final FileTransferProxy serviceProxy = app.getServiceProxy();
      final FileTransferConnection connection = app.getConnection();
      final long size = selFile.size();
      serviceProxy.upload(connection, remotePath, localFilePath, size);
      localPanel.refresh();

      final FileTransferClientQueuePanel queuePanel = app.getQueuePanel();
      queuePanel.refresh();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  final public ImageIcon getStandardImageIcon() {
    return ApplicationImages.ICON_RIGHT_16;
  }

  /**
   * Construtor
   * 
   * @param application aplicao
   */
  public UploadAction(final FileTransferClient application) {
    super(application);
  }
}
