/*
 * $Id$
 */
package csbase.client.project.tasks;

import java.awt.Window;

import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;

/**
 * Classe que implementa a tarefa de ajustar o out-of-date em todo projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class GetFileTask extends CoreTask<ClientProjectFile> {

  /**
   * Projeto consultado.
   */
  final private CommonClientProject project;

  /**
   * O path
   */
  final private String[] path;

  /**
   * Construtor.
   * 
   * @param project o projeto.
   * @param path o path cosultado.
   */
  public GetFileTask(final CommonClientProject project, final String[] path) {
    this.project = project;
    this.path = path;
  }

  /**
   * {@inheritDoc}
   * 
   * Faz a chamada remota (lado cliente).
   * 
   * @see CommonClientProject#setOutOfDate()
   */
  @Override
  protected void performTask() throws Exception {
    final ClientProjectFile file = project.getFile(path);
    setResult(file);
  }

  /**
   * Mtodo de convenincia para chamada automtica da task.
   * 
   * @param project o projeto
   * @param path o path
   * @return o arquivo.
   */
  static final public ClientProjectFile runTask(
    final CommonClientProject project, final String[] path) {
    final ClientProjectFile file = runTask(null, project, path);
    return file;

  }

  /**
   * Mtodo de convenincia para chamada automtica da task.
   * 
   * @param owner janela-me para a task.
   * @param project o projeto
   * @param path o path
   * @return o arquivo.
   */
  static final public ClientProjectFile runTask(Window owner,
    final CommonClientProject project, final String[] path) {
    final GetFileTask task = new GetFileTask(project, path);
    final String projectName = project.getName();
    final boolean hasResult = task.execute(owner, new String[] { projectName });

    if (!hasResult) {
      return null;
    }
    final ClientProjectFile file = task.getResult();
    return file;
  }
}
