/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.AbstractPermissionPanel;
import csbase.client.ias.PermissionInfoDialog;
import csbase.logic.Permission;
import csbase.logic.UserPasswordPermission;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;

class UserPasswordPanel
extends AbstractPermissionPanel {
    private JLabel loginL = new JLabel(LNG.get((String)"IAS_USER") + ":");
    private JTextField login = new JTextField(20);
    private JLabel passwordL = new JLabel(LNG.get((String)"IAS_PERMISSION_PASSWORD") + ":");
    private JPasswordField password = new JPasswordField(20);
    private JLabel confirmPasswordL = new JLabel(LNG.get((String)"IAS_CONFIRM_PERMISSION_PASSWORD") + ":");
    private JPasswordField confirmPassword = new JPasswordField(20);
    private boolean isNew = true;

    UserPasswordPanel(PermissionInfoDialog dialog) {
        super((LayoutManager)new GridBagLayout(), dialog);
        GBC gbc = new GBC(0, 0).northwest().insets(5, 10, 10, 5);
        this.add((Component)this.loginL, gbc);
        gbc = new GBC(1, 0).horizontal().northwest().insets(5, 0, 5, 10).filly();
        this.add((Component)this.login, gbc);
        gbc = new GBC(2, 0).northwest().insets(5, 0, 10, 10);
        this.add((Component)this.passwordL, gbc);
        gbc = new GBC(3, 0).horizontal().northwest().insets(5, 0, 5, 10).filly();
        this.add((Component)this.password, gbc);
        gbc = new GBC(2, 1).northwest().insets(5, 0, 15, 5);
        this.add((Component)this.confirmPasswordL, gbc);
        gbc = new GBC(3, 1).horizontal().northwest().insets(5, 0, 10, 10).filly();
        this.add((Component)this.confirmPassword, gbc);
    }

    @Override
    void importFrom(Permission permission) {
        this.isNew = false;
        UserPasswordPermission userPwdPermission = (UserPasswordPermission)permission;
        this.login.setText(userPwdPermission.getUser());
        KeyAdapter keyChangeListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                UserPasswordPanel.this.dialog.checkDataChange();
            }
        };
        this.login.addKeyListener(keyChangeListener);
        this.password.addKeyListener(keyChangeListener);
    }

    @Override
    void exportTo(Permission permission) {
        UserPasswordPermission userPwdPermission = (UserPasswordPermission)permission;
        userPwdPermission.setUser(this.getLogin());
        userPwdPermission.setPassword(new String(this.getPassword()));
    }

    public String getLogin() {
        return this.login.getText().trim();
    }

    public char[] getPassword() {
        return this.password.getPassword();
    }

    public char[] getConfirmPassword() {
        return this.confirmPassword.getPassword();
    }

    @Override
    void clearFields() {
        this.login.setText("");
        this.password.setText("");
        this.confirmPassword.setText("");
    }

    void clearPasswordFields() {
        this.password.setText("");
        this.confirmPassword.setText("");
    }

    @Override
    public PermissionInfoDialog.FieldsState validateFields() {
        String loginText = this.getLogin();
        if (loginText.equals("")) {
            return PermissionInfoDialog.FieldsState.EMPTY_FIELDS;
        }
        char[] passwordChars = this.getPassword();
        String passwordText = new String(passwordChars).trim();
        char[] confirmPasswordChars = this.getConfirmPassword();
        String confirmPasswordText = new String(confirmPasswordChars).trim();
        if (!this.isNew && passwordText.equals("") != confirmPasswordText.equals("")) {
            return PermissionInfoDialog.FieldsState.EMPTY_FIELDS;
        }
        if (this.isNew && (passwordText.equals("") || confirmPasswordText.equals(""))) {
            return PermissionInfoDialog.FieldsState.EMPTY_FIELDS;
        }
        if (!passwordText.equals(confirmPasswordText)) {
            return PermissionInfoDialog.FieldsState.PASSWORDS_DONT_MATCH;
        }
        return PermissionInfoDialog.FieldsState.FIELDS_OK;
    }

    @Override
    boolean hasChanged(Permission permission) {
        UserPasswordPermission userPwdPermission = (UserPasswordPermission)permission;
        if (!this.getLogin().equals(userPwdPermission.getUser())) {
            return true;
        }
        String passwordText = new String(this.getPassword()).trim();
        return !passwordText.equals("");
    }
}

