/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.gui.log.actions.core;

import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.gui.log.LogPanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public abstract class AbstractLogAction
extends AbstractAction {
    protected static final String TAG_NAME = "name";
    protected static final String TAG_MNEMONIC = "mnemonic";
    protected static final String TAG_TOOLTIP = "tooltip";
    private final LogPanel logPanel;

    protected AbstractLogAction(LogPanel logPanel, ImageIcon icon) {
        this(logPanel);
        this.putValue("SmallIcon", icon);
    }

    protected AbstractLogAction(LogPanel logPanel) {
        String tooltip;
        Integer mnemonic;
        this.logPanel = logPanel;
        String name = this.getName();
        if (name != null) {
            this.putValue("Name", name);
        }
        if ((mnemonic = this.getMnemonic()) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((tooltip = this.getToolTipText()) != null) {
            this.putValue("ShortDescription", tooltip);
        }
    }

    protected final LogPanel getLogPanel() {
        return this.logPanel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            JComponent cmp = (JComponent)ae.getSource();
            this.actionDone(cmp);
        }
        catch (Exception e) {
            Window window = this.getLogPanel().getOwner();
            String title = this.getLogPanel().getTitle();
            StandardErrorDialogs.showErrorDialog(window, title, (Throwable)e);
        }
    }

    protected final String getString(String key, Object ... args) {
        String className = this.getClass().getSimpleName();
        String formattedKey = String.format("%s.%s", className, key);
        return LogPanel.getString(formattedKey, args);
    }

    public final String getName() {
        return this.getString(TAG_NAME, new Object[0]);
    }

    public final String getToolTipText() {
        return this.getString(TAG_TOOLTIP, new Object[0]);
    }

    private final Integer getMnemonic() {
        String mn = this.getString(TAG_MNEMONIC, new Object[0]);
        if (mn == null || "".equals(mn)) {
            return null;
        }
        return mn.charAt(0);
    }

    public abstract void actionDone(JComponent var1) throws Exception;
}

