/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.versiontree.actions;

import csbase.client.applications.algorithmsmanager.dialogs.VersionDialog;
import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;
import csbase.client.applications.algorithmsmanager.versiontree.actions.AbstractImportFileAction;
import csbase.client.desktop.RemoteTask;
import csbase.client.desktop.Task;
import csbase.client.externalresources.ExternalResources;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import java.awt.Component;
import java.net.URL;
import java.rmi.RemoteException;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class ImportConfigurationFile
extends AbstractImportFileAction {
    private final AlgorithmVersionInfo version;

    public ImportConfigurationFile(VersionTree tree, AlgorithmVersionInfo version) {
        super(tree, LNG.get((String)"algomanager.menu.config.add"), 2, true);
        this.version = version;
    }

    @Override
    protected Task<Boolean> createCheckFileExistenceTask(final String fileName) {
        return new RemoteTask<Boolean>(){

            protected void performTask() throws Exception {
                AlgorithmInfo algorithm = ImportConfigurationFile.this.version.getInfo();
                this.setResult(ClientRemoteLocator.algorithmService.configFileExists((Object)algorithm.getId(), (Object)ImportConfigurationFile.this.version.getId(), fileName));
            }
        };
    }

    @Override
    protected RemoteFileChannelInfo prepareUpload(String fileName, boolean isZipLocalFile) throws RemoteException {
        AlgorithmInfo algorithm = this.version.getInfo();
        return ClientRemoteLocator.algorithmService.prepareUploadConfigFile((Object)algorithm.getId(), (Object)this.version.getId(), fileName, isZipLocalFile);
    }

    @Override
    protected void appletUpload() {
        new UploadConfiguratorDialog().uploadConfigurator();
    }

    private class UploadConfiguratorDialog
    extends VersionDialog {
        public UploadConfiguratorDialog() {
            super(ImportConfigurationFile.this.version.getInfo());
        }

        public void uploadConfigurator() {
            String algoId = this.algoInfo.getId();
            if (ExternalResources.getInstance().isEnabled()) {
                String addr = AlgorithmManagementProxy.getConfiguratorURL(algoId, ImportConfigurationFile.this.version.getId(), ImportConfigurationFile.this.getWindow());
                if (addr == null) {
                    return;
                }
                try {
                    URL url = new URL(addr);
                    ExternalResources.getInstance().showDocument(url);
                }
                catch (Exception ex) {
                    StandardErrorDialogs.showErrorDialog(ImportConfigurationFile.this.getWindow(), this.dialogTitle, LNG.get((String)"PRJ_PROJECT_FILE_UPLOAD_IO_ERROR"), ex);
                }
            } else {
                StandardDialogs.showInfoDialog((Component)ImportConfigurationFile.this.getWindow(), (String)this.dialogTitle, (Object)LNG.get((String)"algomanager.error.upload_not_available"));
            }
        }
    }
}

