/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.StandardErrorDialogs;
import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.Permission;
import csbase.logic.Role;
import csbase.logic.RoleInfo;
import csbase.logic.User;
import csbase.logic.UserInfo;
import csbase.logic.Utilities;
import java.awt.Component;
import java.awt.Window;
import java.util.List;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class PermissionProxy {
    public static Vector<Permission> getAllPermissions(Window owner, String title, String message) {
        RemoteTask<Vector<Permission>> task = new RemoteTask<Vector<Permission>>(){

            public void performTask() throws Exception {
                this.setResult(new Vector(Permission.getAllPermissions()));
            }
        };
        if (task.execute(owner, title, message)) {
            Vector unsVector = (Vector)task.getResult();
            if (unsVector == null || unsVector.size() <= 0) {
                return new Vector<Permission>();
            }
            return unsVector;
        }
        return new Vector<Permission>();
    }

    public static Permission getPermission(Window owner, String title, String message, final Object permissionId) {
        RemoteTask<Permission> task = new RemoteTask<Permission>(){

            public void performTask() throws Exception {
                this.setResult(Permission.getPermission((Object)permissionId));
            }
        };
        if (task.execute(owner, title, message)) {
            return (Permission)task.getResult();
        }
        return null;
    }

    public static Permission createPermission(Window owner, String title, String message, final Permission permission) {
        RemoteTask<Permission> task = new RemoteTask<Permission>(){

            public void performTask() throws Exception {
                this.setResult(Permission.createPermission((Permission)permission));
            }
        };
        if (task.execute(owner, title, message)) {
            Permission perm = (Permission)task.getResult();
            if (perm == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_PERMISSION_ALREADY_EXISTS_ERROR"));
            }
            return perm;
        }
        return null;
    }

    public static Permission modifyPermission(Window owner, String title, String message, final Object permissionId, final Permission modifiedPermission) {
        RemoteTask<Permission> task = new RemoteTask<Permission>(){

            public void performTask() throws Exception {
                this.setResult(Permission.modifyPermission((Object)permissionId, (Permission)modifiedPermission));
            }
        };
        if (task.execute(owner, title, message)) {
            Permission perm = (Permission)task.getResult();
            if (perm == null) {
                StandardErrorDialogs.showErrorDialog(owner, title, LNG.get((String)"IAS_PERMISSION_ALREADY_EXISTS_ERROR"));
            }
            return perm;
        }
        return null;
    }

    public static void deletePermission(final Window owner, final String title, String message, final Object permissionId) {
        class DeletePermissionRemoteTask
        extends RemoteTask<Void> {
            boolean removeUsersPermission = false;

            DeletePermissionRemoteTask() {
            }

            public void performTask() throws Exception {
                Permission.deletePermission((Object)permissionId);
            }

            @Override
            protected void handleError(Exception error) {
                if (error instanceof AdministrationDeleteException) {
                    String errorMsg = LNG.get((String)"IAS_CONFIRM_PERMISSION_REMOVAL");
                    int res = StandardDialogs.showYesNoDialog((Component)owner, (String)title, (Object)errorMsg);
                    if (res == 0) {
                        this.removeUsersPermission = true;
                    }
                } else {
                    super.handleError(error);
                }
            }
        }
        DeletePermissionRemoteTask deletetask = new DeletePermissionRemoteTask();
        if (!deletetask.execute(owner, title, message) && deletetask.removeUsersPermission) {
            RemoteTask<Void> task = new RemoteTask<Void>(){

                public void performTask() throws Exception {
                    List roles = Role.getAllRoles();
                    block0: for (int i = 0; i < roles.size(); ++i) {
                        Role role = (Role)roles.get(i);
                        Object[] permissionIds = role.getPermissionIds();
                        for (int j = 0; j < permissionIds.length; ++j) {
                            if (!permissionIds[j].equals(permissionId)) continue;
                            RoleInfo roleInfo = role.getRoleInfo();
                            roleInfo.permissionIds = Utilities.removeItemFromArray((Object[])permissionIds, (int)j);
                            Role.modifyRole((Object)role.getId(), (RoleInfo)roleInfo);
                            continue block0;
                        }
                    }
                    List users = User.getAllUsers();
                    block2: for (int i = 0; i < users.size(); ++i) {
                        User user = (User)users.get(i);
                        Object[] permissionIds = user.getPermissionIds();
                        for (int j = 0; j < permissionIds.length; ++j) {
                            if (!permissionIds[j].equals(permissionId)) continue;
                            Object[] remainingPermissionIds = Utilities.removeItemFromArray((Object[])permissionIds, (int)j);
                            UserInfo userInfo = user.getUserInfo();
                            userInfo.setAttribute("permissionIds", (Object)remainingPermissionIds);
                            User.modifyUser((Object)user.getId(), (UserInfo)userInfo);
                            user.setPermissionIds(remainingPermissionIds);
                            continue block2;
                        }
                    }
                    Permission.deletePermission((Object)permissionId);
                }
            };
            task.execute(owner, title, message);
        }
    }

    public static Vector<String> getPermissionClasses(Window owner, String title, String message) {
        RemoteTask<Vector<String>> task = new RemoteTask<Vector<String>>(){

            public void performTask() throws Exception {
                this.setResult(new Vector(Permission.getPermissionClasses()));
            }
        };
        if (task.execute(owner, title, message)) {
            Vector classesVector = (Vector)task.getResult();
            if (classesVector == null || classesVector.size() <= 0) {
                return new Vector<String>();
            }
            return classesVector;
        }
        return new Vector<String>();
    }
}

