/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.zoom.combo;

import csbase.client.applications.flowapplication.zoom.ZoomListener;
import csbase.client.applications.flowapplication.zoom.ZoomModel;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;

class ZoomComboModel
extends DefaultComboBoxModel {
    private ArrayList<ZoomComboItem> defaultItems = new ArrayList();
    private ArrayList<ZoomComboItem> extraItems = new ArrayList();
    private ZoomModel zoomModel;
    private boolean notify = true;
    private static final int EXTRA_ITEMS_LIMIT = 3;
    private static int MODEL_FACTOR = 100;

    private ZoomComboItem createComboItem(double value) {
        ZoomComboItem newItem = new ZoomComboItem(value);
        if (this.getIndexOf(newItem) == -1) {
            if (this.extraItems.size() > 3) {
                this.extraItems.remove(0);
            }
            this.extraItems.add(newItem);
            this.updateObjects();
        }
        return newItem;
    }

    private void updateObjects() {
        ArrayList<ZoomComboItem> arrayList = new ArrayList<ZoomComboItem>(this.defaultItems);
        arrayList.addAll(this.extraItems);
        Collections.sort(arrayList);
        this.removeAllElements();
        this.notify = false;
        for (ZoomComboItem item : arrayList) {
            this.addElement(item);
        }
        this.notify = true;
    }

    void setValue(double value) {
        ZoomComboItem item = this.createComboItem(value);
        super.setSelectedItem(item);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        ZoomComboItem item;
        Double value = null;
        if (anObject instanceof ZoomComboItem) {
            super.setSelectedItem(anObject);
            value = ((ZoomComboItem)anObject).getValue();
        } else if (anObject instanceof String && (item = this.parseInput(anObject)) != null) {
            super.setSelectedItem(item);
            value = item.getValue();
        }
        if (this.notify && value != null) {
            this.zoomModel.setValue(value);
        }
    }

    private ZoomComboItem parseInput(Object anObject) {
        String newVal = (String)anObject;
        char lastChar = (newVal = newVal.trim()).charAt(newVal.length() - 1);
        if (lastChar == '%') {
            newVal = newVal.substring(0, newVal.length() - 1);
        }
        try {
            double value = Double.parseDouble(newVal);
            value /= (double)MODEL_FACTOR;
            if (value > this.zoomModel.getMaxValue()) {
                return this.createComboItem(this.zoomModel.getMaxValue());
            }
            if (value < this.zoomModel.getMinValue()) {
                return this.createComboItem(this.zoomModel.getMinValue());
            }
            return this.createComboItem(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void createDefaultItems() {
        this.notify = false;
        this.defaultItems.add(new ZoomComboItem(0.5));
        this.defaultItems.add(new ZoomComboItem(0.75));
        ZoomComboItem zoomComboItem = new ZoomComboItem(1.0);
        this.defaultItems.add(zoomComboItem);
        this.defaultItems.add(new ZoomComboItem(1.5));
        this.defaultItems.add(new ZoomComboItem(2.0));
        this.defaultItems.add(new ZoomComboItem(4.0));
        Collections.sort(this.defaultItems);
        this.setSelectedItem(zoomComboItem);
        this.notify = true;
    }

    ZoomComboModel(ZoomModel zoomModel) {
        this.zoomModel = zoomModel;
        this.createDefaultItems();
        for (ZoomComboItem item : this.defaultItems) {
            this.addElement(item);
        }
        zoomModel.addListener(new ZoomModelComboListner(this));
    }

    private class ZoomModelComboListner
    implements ZoomListener {
        private ZoomComboModel zoomComboModel;

        ZoomModelComboListner(ZoomComboModel model) {
            this.zoomComboModel = model;
        }

        @Override
        public void wasChanged(ZoomModel model) {
            double value = model.getValue();
            this.zoomComboModel.setValue(value);
        }
    }

    private class ZoomComboItem
    implements Comparable<ZoomComboItem> {
        private double value;

        ZoomComboItem(double value) {
            this.value = value;
        }

        public String toString() {
            int a = (int)((double)MODEL_FACTOR * this.value);
            return a + "%";
        }

        private double getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ZoomComboItem) {
                double other = ((ZoomComboItem)obj).getValue();
                other *= 10.0;
                other = (double)Math.round(other) / 10.0;
                double myself = this.getValue() * 10.0;
                if ((myself = (double)Math.round(myself) / 10.0) == other) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compareTo(ZoomComboItem o) {
            if (this.getValue() < o.getValue()) {
                return -1;
            }
            if (this.getValue() > o.getValue()) {
                return 1;
            }
            return 0;
        }
    }
}

