/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project;

import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.ProjectTreeListener;
import csbase.client.project.ProjectTreeModel;
import csbase.client.project.ProjectTreeMouseAdapter;
import csbase.client.project.ProjectTreeNode;
import csbase.client.project.ProjectTreeRenderer;
import csbase.client.project.ProjectTreeSelectionEvent;
import csbase.client.project.ProjectTreeSelectionListener;
import csbase.client.project.ProjectTreeSelectionModel;
import csbase.client.project.ProjectTreeStructureListenerImpl;
import csbase.client.project.ProjectTreeTransferHandler;
import csbase.client.project.ProjectTreeWillExpandListener;
import csbase.client.project.RecentProjectsManager;
import csbase.client.project.action.CommonFileCopyAction;
import csbase.client.project.action.CommonFileCutAction;
import csbase.client.project.action.CommonFileDeleteAction;
import csbase.client.project.action.CommonFilePasteAction;
import csbase.client.project.action.CommonFileRenameAction;
import csbase.client.project.action.ProjectTreeUpdateAction;
import csbase.client.project.tasks.GetChildFromPathTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectBasicInfo;
import csbase.logic.ProjectFileFilter;
import csbase.logic.filetypefinder.FileTypeFinder;
import java.awt.Window;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tecgraf.javautils.core.lng.LNG;

public class ProjectTree
implements ProjectFileContainer {
    private JTree tree;
    private Window owner;
    private String title;
    private Vector<ProjectTreeListener> projectTreeListenerList;
    private JPopupMenu popupRoot;
    private JPopupMenu popupDir;
    private JPopupMenu popupDataset;
    private JPopupMenu popupMultSelection;
    private JPopupMenu popupFile;
    private CommonClientProject project;
    private List<ProjectTreeSelectionListener> treeSelectionListenerList;
    private ProjectTreeCellEditor editor;
    protected boolean transferEnabled;
    protected boolean deleteEnabled;
    protected boolean renameEnabled;
    protected boolean refreshEnabled;

    public void setPopupRoot(JPopupMenu popupRoot) {
        this.popupRoot = popupRoot;
    }

    public JPopupMenu getPopupRoot() {
        return this.popupRoot;
    }

    public void setPopupFile(JPopupMenu popupFile) {
        this.popupFile = popupFile;
    }

    public JPopupMenu getPopupFile() {
        return this.popupFile;
    }

    public void setPopupMultSelection(JPopupMenu popupMultSelection) {
        this.popupMultSelection = popupMultSelection;
    }

    public JPopupMenu getPopupMultSelection() {
        return this.popupMultSelection;
    }

    public void setPopupDataset(JPopupMenu popupDataset) {
        this.popupDataset = popupDataset;
    }

    public JPopupMenu getPopupDataset() {
        return this.popupDataset;
    }

    public void setPopupDir(JPopupMenu popupDir) {
        this.popupDir = popupDir;
    }

    public JPopupMenu getPopupDir() {
        return this.popupDir;
    }

    @Override
    public Window getWindow() {
        return this.owner;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public void clearSelection() {
        this.tree.clearSelection();
    }

    public boolean addTreeSelectionListener(ProjectTreeSelectionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 permitido adicionar um ouvinte nulo (null).");
        }
        return this.treeSelectionListenerList.add(listener);
    }

    public boolean removeTreeSelectionListener(ProjectTreeSelectionListener listener) {
        return this.treeSelectionListenerList.remove(listener);
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.tree.getModel().addTreeModelListener(listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.tree.getModel().removeTreeModelListener(listener);
    }

    public Vector<ProjectTreeListener> getListeners() {
        return this.projectTreeListenerList;
    }

    public void setSelectionPath(String[] selectedPath) {
        ClientProjectFile root = this.project.getRoot();
        ClientProjectFile file = selectedPath == null ? root : GetChildFromPathTask.runTask(root, selectedPath);
        ProjectTreeModel treeModel = (ProjectTreeModel)this.tree.getModel();
        TreePath treePath = treeModel.getTreePath(file);
        this.tree.expandPath(treePath.getParentPath());
        this.tree.setSelectionPath(treePath);
    }

    public void setSelectionPath(TreePath selectedPath) {
        this.tree.setSelectionPath(selectedPath);
    }

    @Override
    public CommonClientProject getProject() {
        return this.project;
    }

    public void setComparator(Comparator<ProjectTreeNode> comparator) {
        ProjectTreeModel treeModel = (ProjectTreeModel)this.tree.getModel();
        treeModel.setComparator(comparator);
    }

    public void setProject(CommonClientProject newProject) {
        this.clearSelection();
        this.project = newProject;
        ProjectTreeModel treeModel = (ProjectTreeModel)this.tree.getModel();
        treeModel.setProject(this.project);
        this.setDefaultTreeExpansionState();
        if (this.project != null) {
            ProjectBasicInfo info = new ProjectBasicInfo(this.project.getId(), this.project.getName(), this.project.getUserId());
            this.saveProjectAsRecent(info);
        }
        this.notifyProjectWasChanged(this.project);
        this.notifyProjectWasRemoved();
    }

    private void saveProjectAsRecent(final ProjectBasicInfo projectBasicInfo) {
        final RecentProjectsManager manager = new RecentProjectsManager();
        RemoteTask<Void> task = new RemoteTask<Void>(){

            protected void performTask() throws Exception {
                manager.saveProjectInfo(projectBasicInfo);
            }
        };
        task.execute(this.owner, this.title, LNG.get((String)"ProjectTree.task.save.project.as.recent.msg"));
        if (!task.getStatus()) {
            System.out.println("Erro na persist\u00eancia de Projetos Recentes. Projeto: " + projectBasicInfo.getProjectId());
        }
    }

    private void setDefaultTreeExpansionState() {
        ProjectTreeNode root = (ProjectTreeNode)this.tree.getModel().getRoot();
        if (root == null) {
            return;
        }
        TreePath rootPath = new TreePath(root);
        if (root.getChildCount() >= 0) {
            Enumeration<ProjectTreeNode> e = root.children();
            while (e.hasMoreElements()) {
                TreeNode node = e.nextElement();
                TreePath nodePath = rootPath.pathByAddingChild(node);
                this.tree.collapsePath(nodePath);
            }
        }
        this.tree.expandPath(rootPath);
    }

    public void resetProject() {
        this.setProject(null);
    }

    public void closeProject() {
        if (this.project == null) {
            throw new IllegalStateException("N\u00e3o \u00e9 poss\u00edvel fechar o projeto, pois n\u00e3o existe projeto.");
        }
        this.notifyProjectWasClosed(this.project);
    }

    public void setSingleSelectionMode(boolean singleSelection) {
        int mode = singleSelection ? 1 : 4;
        this.tree.getSelectionModel().setSelectionMode(mode);
    }

    @Override
    public ClientProjectFile getSelectedFile() {
        if (this.project == null) {
            return null;
        }
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        ProjectTreeNode treeNode = (ProjectTreeNode)path.getLastPathComponent();
        ClientProjectFile file = treeNode.getClientProjectFile();
        return file;
    }

    @Override
    public ClientProjectFile[] getSelectedFiles() {
        if (this.project == null) {
            return null;
        }
        TreePath[] path = this.tree.getSelectionPaths();
        if (path == null) {
            return null;
        }
        if (path.length == 0) {
            return null;
        }
        ClientProjectFile[] file = new ClientProjectFile[path.length];
        for (int i = 0; i < path.length; ++i) {
            ProjectTreeNode treeNode = (ProjectTreeNode)path[i].getLastPathComponent();
            file[i] = treeNode.getClientProjectFile();
        }
        return file;
    }

    public void setOutOfDate() {
        this.getProject().setOutOfDate();
        this.repaint();
        this.notifyInfoWasModified();
    }

    @Override
    public void enableTransferAction(boolean enable) {
        if (enable) {
            this.tree.setTransferHandler(new ProjectTreeTransferHandler(this.owner, this.title));
            this.tree.setDragEnabled(true);
        } else {
            this.tree.setDragEnabled(false);
            this.tree.setTransferHandler(null);
        }
        this.transferEnabled = enable;
        this.enableTransferKeyBindings(enable);
    }

    private void enableTransferKeyBindings(boolean enable) {
        KeyStroke cutKey = KeyStroke.getKeyStroke("ctrl X");
        KeyStroke copyKey = KeyStroke.getKeyStroke("ctrl C");
        KeyStroke pasteKey = KeyStroke.getKeyStroke("ctrl V");
        InputMap inputMap = this.tree.getInputMap();
        ActionMap actionMap = this.tree.getActionMap();
        if (enable) {
            CommonFileCutAction cutAction = new CommonFileCutAction(this);
            CommonFileCopyAction copyAction = new CommonFileCopyAction(this);
            CommonFilePasteAction pasteAction = new CommonFilePasteAction(this);
            inputMap.put(cutKey, cutAction.getValue("Name"));
            inputMap.put(copyKey, copyAction.getValue("Name"));
            inputMap.put(pasteKey, pasteAction.getValue("Name"));
            actionMap.put(cutAction.getValue("Name"), cutAction);
            actionMap.put(copyAction.getValue("Name"), copyAction);
            actionMap.put(pasteAction.getValue("Name"), pasteAction);
        } else {
            String actionName = (String)inputMap.get(cutKey);
            actionMap.remove(actionName);
            inputMap.remove(cutKey);
            actionName = (String)inputMap.get(copyKey);
            actionMap.remove(actionName);
            inputMap.remove(copyKey);
            actionName = (String)inputMap.get(pasteKey);
            actionMap.remove(actionName);
            inputMap.remove(pasteKey);
        }
    }

    private void fireUpdateSelection(ClientProjectFile[] selectedFiles) {
        ProjectTreeSelectionEvent treeSelectionEvent = new ProjectTreeSelectionEvent(this, selectedFiles);
        for (ProjectTreeSelectionListener listener : this.treeSelectionListenerList) {
            listener.update(treeSelectionEvent);
        }
    }

    @Override
    public void enableRenameAction(boolean enable) {
        if (enable) {
            this.tree.setEditable(true);
            this.tree.setCellEditor(this.editor);
        } else {
            this.tree.setEditable(false);
            this.tree.setCellEditor(null);
        }
        this.renameEnabled = enable;
    }

    @Override
    public void startRenamingAction() {
        this.tree.startEditingAtPath(this.tree.getSelectionPath());
    }

    @Override
    public void startCutAction() {
        TransferHandler handler = this.tree.getTransferHandler();
        handler.exportToClipboard(this.tree, null, 2);
    }

    @Override
    public void startCopyAction() {
        TransferHandler handler = this.tree.getTransferHandler();
        handler.exportToClipboard(this.tree, null, 1);
    }

    @Override
    public void startPasteAction() {
        TransferHandler handler = this.tree.getTransferHandler();
        handler.importData(this.tree, null);
    }

    @Override
    public void enableDeleteAction(boolean enable) {
        KeyStroke delKey = KeyStroke.getKeyStroke("DELETE");
        if (enable) {
            CommonFileDeleteAction deleteAction = new CommonFileDeleteAction(this);
            String actionName = (String)deleteAction.getValue("Name");
            this.tree.getInputMap().put(delKey, actionName);
            this.tree.getActionMap().put(actionName, deleteAction);
        } else {
            String actionName = (String)this.tree.getInputMap().get(delKey);
            this.tree.getActionMap().remove(actionName);
            this.tree.getInputMap().remove(delKey);
        }
        this.deleteEnabled = enable;
    }

    @Override
    public void enableRefreshAction(boolean enable) {
        KeyStroke refreshKey = KeyStroke.getKeyStroke("F5");
        if (enable) {
            ProjectTreeUpdateAction refreshAction = new ProjectTreeUpdateAction(this);
            String actionName = (String)refreshAction.getValue("Name");
            this.tree.getInputMap().put(refreshKey, actionName);
            this.tree.getActionMap().put(actionName, refreshAction);
        } else {
            String actionName = (String)this.tree.getInputMap().get(refreshKey);
            this.tree.getActionMap().remove(actionName);
            this.tree.getInputMap().remove(refreshKey);
        }
        this.refreshEnabled = enable;
    }

    @Override
    public void clearClipboard() {
        ProjectTreeTransferHandler handler = (ProjectTreeTransferHandler)this.tree.getTransferHandler();
        handler.clearClipboard();
    }

    public void setVisualFilter(ProjectFileFilter filter) {
        ProjectTreeModel treeModel = (ProjectTreeModel)this.tree.getModel();
        treeModel.setFilter(filter);
    }

    public void setSelectionFilter(ProjectFileFilter filter) {
        ProjectTreeSelectionModel treeSelectionModel = (ProjectTreeSelectionModel)this.tree.getSelectionModel();
        treeSelectionModel.setFilter(filter);
    }

    private void makeTree(ProjectFileFilter visualFilter, ProjectFileFilter selectionFilter) {
        ProjectTreeModel model = visualFilter == null ? new ProjectTreeModel(this.project) : new ProjectTreeModel(this.project, visualFilter);
        this.tree = new JTree(model);
        this.tree.setLargeModel(true);
        if (selectionFilter == null) {
            this.tree.setSelectionModel(new ProjectTreeSelectionModel());
        } else {
            this.tree.setSelectionModel(new ProjectTreeSelectionModel(selectionFilter));
        }
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        ProjectTreeRenderer renderer = new ProjectTreeRenderer();
        this.tree.setCellRenderer(renderer);
        this.editor = new ProjectTreeCellEditor(new CommonFileRenameAction(this), this.tree, renderer);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setShowsRootHandles(true);
        model.addTreeWillChangeStructureListener(new ProjectTreeStructureListenerImpl(this.tree));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                LinkedList<ClientProjectFile> selectedFilesList = new LinkedList<ClientProjectFile>();
                TreePath[] treePathArray = e.getPaths();
                for (int i = 0; i < treePathArray.length; ++i) {
                    if (!e.isAddedPath(i)) continue;
                    ProjectTreeNode selectedNode = (ProjectTreeNode)treePathArray[i].getLastPathComponent();
                    ClientProjectFile selectedFile = selectedNode.getClientProjectFile();
                    selectedFilesList.add(selectedFile);
                }
                ClientProjectFile[] selectedFiles = selectedFilesList.toArray(new ClientProjectFile[selectedFilesList.size()]);
                ProjectTree.this.fireUpdateSelection(selectedFiles);
            }
        });
        this.tree.addTreeWillExpandListener(new ProjectTreeWillExpandListener((ProjectTreeModel)this.tree.getModel()));
        this.enableDeleteAction(true);
        this.enableRefreshAction(true);
        this.enableRenameAction(true);
        this.enableTransferAction(true);
    }

    public void addMouseListener() {
        this.tree.addMouseListener(new ProjectTreeMouseAdapter(this){

            @Override
            public void doubleClickAction(ClientProjectFile file) {
                if (ProjectTree.this.doubleClickIntercepted(file)) {
                    return;
                }
                this.fireOpenAction(file);
            }
        });
    }

    protected boolean doubleClickIntercepted(ClientProjectFile file) {
        return false;
    }

    public void addProjectTreeListener(ProjectTreeListener listener) {
        this.projectTreeListenerList.add(listener);
    }

    public void removeProjectTreeListener(ProjectTreeListener listener) {
        this.projectTreeListenerList.remove(listener);
    }

    private void notifyProjectWasChanged(CommonClientProject proj) {
        Enumeration<ProjectTreeListener> elem = this.projectTreeListenerList.elements();
        while (elem.hasMoreElements()) {
            ProjectTreeListener listener = elem.nextElement();
            listener.projectChanged(proj);
        }
    }

    private void notifyProjectWasClosed(CommonClientProject proj) {
        Enumeration<ProjectTreeListener> elem = this.projectTreeListenerList.elements();
        while (elem.hasMoreElements()) {
            ProjectTreeListener listener = elem.nextElement();
            listener.projectClosed(proj);
        }
    }

    private void notifyProjectWasRemoved() {
        Enumeration<ProjectTreeListener> elem = this.projectTreeListenerList.elements();
        while (elem.hasMoreElements()) {
            ProjectTreeListener listener = elem.nextElement();
            listener.projectRemoved();
        }
    }

    private void notifyInfoWasModified() {
        Enumeration<ProjectTreeListener> elem = this.projectTreeListenerList.elements();
        while (elem.hasMoreElements()) {
            ProjectTreeListener listener = elem.nextElement();
            listener.projectInfoModified();
        }
    }

    public boolean hasFileToPaste() {
        ProjectTreeTransferHandler transferHandler = (ProjectTreeTransferHandler)this.tree.getTransferHandler();
        return transferHandler != null && transferHandler.hasTransferableInClipboard();
    }

    private TreePath getPathToRoot(ClientProjectFile file) {
        ProjectTreeModel treeModel = (ProjectTreeModel)this.tree.getModel();
        return treeModel.getTreePath(file);
    }

    public void setSelectedFile(ClientProjectFile file) {
        this.setSelectionPath(this.getPathToRoot(file));
    }

    @Override
    public int getSelectionCount() {
        return this.tree.getSelectionCount();
    }

    @Override
    public void repaint() {
        this.tree.repaint();
    }

    public void release() {
        this.setProject(null);
    }

    protected ProjectTree(Window owner, String title) {
        this(owner, title, null, null, null);
    }

    protected ProjectTree(Window owner, String title, CommonClientProject project) {
        this(owner, title, project, null, null);
    }

    protected ProjectTree(Window owner, String title, CommonClientProject project, ProjectFileFilter visualFilter) {
        this(owner, title, project, visualFilter, null);
    }

    public FileTypeFinder getFileTypeFinder() {
        return null;
    }

    protected ProjectTree(Window owner, String title, CommonClientProject project, ProjectFileFilter visualFilter, ProjectFileFilter selectionFilter) {
        if (owner == null) {
            throw new IllegalArgumentException("A janela pai da \u00e1rvore n\u00e3o pode ser nula.");
        }
        if (title == null) {
            throw new IllegalArgumentException("O t\u00edtulo da janela pai da \u00e1rvore n\u00e3o pode ser nulo.");
        }
        this.owner = owner;
        this.title = title;
        this.project = project;
        this.treeSelectionListenerList = new LinkedList<ProjectTreeSelectionListener>();
        this.projectTreeListenerList = new Vector();
        this.makeTree(visualFilter, selectionFilter);
    }

    private class ProjectTreeCellEditor
    extends DefaultTreeCellEditor {
        @Override
        public boolean isCellEditable(EventObject event) {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                return false;
            }
            ProjectTreeNode treeNode = (ProjectTreeNode)path.getLastPathComponent();
            ClientProjectFile file = treeNode.getClientProjectFile();
            if (file.isUnderConstruction()) {
                return false;
            }
            if (file.getParent() == null) {
                return false;
            }
            return super.isCellEditable(event);
        }

        ProjectTreeCellEditor(CommonFileRenameAction action, JTree tree, DefaultTreeCellRenderer renderer) {
            this(action, tree, renderer, null);
        }

        ProjectTreeCellEditor(final CommonFileRenameAction action, final JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
            super(tree, renderer, editor);
            this.addCellEditorListener(new CellEditorListener(){

                private void rename() {
                    String newName;
                    TreePath path = tree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    ProjectTreeNode selectedNode = (ProjectTreeNode)path.getLastPathComponent();
                    ClientProjectFile file = selectedNode.getClientProjectFile();
                    String oldName = file.getName();
                    if (oldName.equals(newName = (String)ProjectTreeCellEditor.this.getCellEditorValue())) {
                        return;
                    }
                    action.rename(file, newName);
                }

                @Override
                public void editingCanceled(ChangeEvent event) {
                    this.rename();
                }

                @Override
                public void editingStopped(ChangeEvent event) {
                    this.rename();
                }
            });
        }

        @Override
        protected TreeCellEditor createTreeCellEditor() {
            Border aBorder = UIManager.getBorder("Tree.editorBorder");
            DefaultTreeCellEditor.DefaultTextField textField = new DefaultTreeCellEditor.DefaultTextField(aBorder){

                @Override
                public void selectAll() {
                    Document doc = this.getDocument();
                    if (doc != null) {
                        this.setCaretPosition(0);
                        this.moveCaretPosition(this.getLastPositionBeforeDot());
                    }
                }

                private int getLastPositionBeforeDot() {
                    String text = this.getText();
                    int pos = text.lastIndexOf(46);
                    if (pos == -1 || pos == 0) {
                        return text.length();
                    }
                    return pos;
                }
            };
            return new DefaultCellEditor(textField);
        }
    }
}

