/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor.actions;

import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.commandsmonitor.CommandsMonitor;
import csbase.client.applications.commandsmonitor.actions.AbstractCommandsAction;
import csbase.client.remote.srvproxies.SGAProxy;
import csbase.client.remote.srvproxies.SchedulerProxy;
import csbase.logic.CommandInfo;
import csbase.logic.CommandStatus;
import java.awt.Component;
import java.awt.event.ActionEvent;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class KillCommandsAction
extends AbstractCommandsAction {
    public KillCommandsAction(CommandsMonitor application) {
        super(application, true, ApplicationImages.ICON_STOP_16);
    }

    @Override
    protected boolean accept(CommandInfo command) {
        return command.getStatus() == CommandStatus.SCHEDULED || command.getStatus() == CommandStatus.UPLOADING || command.getStatus() == CommandStatus.INIT || command.getStatus() == CommandStatus.EXECUTING || command.getStatus() == CommandStatus.DOWNLOADING;
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        this.killCommands(this.getSelectedCommands());
    }

    private boolean killCommands(CommandInfo[] commands) {
        if (!this.warnKillCommand()) {
            return false;
        }
        boolean success = true;
        ApplicationFrame frame = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
        for (int inx = 0; inx < commands.length; ++inx) {
            CommandInfo cmd = commands[inx];
            String cmdId = cmd.getId();
            if (CommandStatus.SCHEDULED.equals((Object)cmd.getStatus())) {
                success &= SchedulerProxy.removeCommand(frame, cmdId);
                continue;
            }
            String sgaName = cmd.getSGAName();
            success &= SGAProxy.killCommand(sgaName, cmdId);
        }
        if (!success) {
            String errorMessage = this.getString("KillCommandsAction.task.commands.kill.error", commands.length);
            ((CommandsMonitor)this.getApplication()).showError(errorMessage);
        }
        return success;
    }

    private boolean warnKillCommand() {
        String message = this.getString("KillCommandsAction.task.commands.kill.confirmation.query", new Object[0]);
        ApplicationFrame frame = ((CommandsMonitor)this.getApplication()).getApplicationFrame();
        String title = frame.getTitle();
        Object[] options = new String[]{LNG.get((String)"UTIL_YES"), LNG.get((String)"UTIL_NO")};
        int option = StandardDialogs.showOptionDialog((Component)frame, (String)title, (Object)message, (Object[])options);
        switch (option) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        String errorMessage = this.getString("KillCommandsAction.task.commands.kill.confirmation.error", option);
        throw new IllegalStateException(errorMessage);
    }
}

