/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.xmlpanel.xmltagtreepanel;

import csbase.client.util.xmlpanel.XMLPanelStyleInterface;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.w3c.dom.Node;

class XMLTagTreeRenderer
extends DefaultTreeCellRenderer {
    private XMLPanelStyleInterface style = null;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean isWithFocus) {
        Node node = (Node)value;
        String textValue = node.getNodeName();
        super.getTreeCellRendererComponent(tree, textValue, sel, expanded, leaf, row, isWithFocus);
        Node parentNode = node.getParentNode();
        TreeModel model = tree.getModel();
        int index = -1;
        if (parentNode != null) {
            index = model.getIndexOfChild(parentNode, node) + 1;
        }
        if (this.style == null) {
            this.setText(textValue);
        } else {
            this.setIcon(this.style.getIcon(node, textValue, index));
            this.setText(this.style.getTreeText(node, textValue, index));
            this.setToolTipText(textValue);
        }
        return this;
    }

    void setStyle(XMLPanelStyleInterface style) {
        this.style = style;
    }

    XMLPanelStyleInterface getStyle() {
        return this.style;
    }

    XMLTagTreeRenderer() {
        this.setOpenIcon(null);
        this.setClosedIcon(null);
        this.setLeafIcon(null);
    }
}

