/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.serverdiagnostic.monitor;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.serverdiagnostic.monitor.DefaultSwingRenderer;
import csbase.client.applications.serverdiagnostic.monitor.StatusGroupTreeNode;
import csbase.client.applications.serverdiagnostic.monitor.StatusNode;
import csbase.client.applications.serverdiagnostic.monitor.SwingRenderer;
import csbase.logic.diagnosticservice.Status;
import csbase.logic.diagnosticservice.StatusCode;
import java.awt.Component;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;

public class StatusTree
extends JTree {
    private SwingRenderer defaultRenderer = new DefaultSwingRenderer();

    public StatusTree(Locale locale, TreeNode node) {
        super(node);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.setSelectionModel(selectionModel);
        this.setShowsRootHandles(true);
        this.setRootVisible(false);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
                JLabel label;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                StatusNode nodeData = (StatusNode)node.getUserObject();
                if (isLeaf) {
                    if (nodeData.name != null) {
                        label = new JLabel(nodeData.name);
                    } else {
                        Status status = nodeData.status;
                        SwingRenderer renderer = StatusTree.this.defaultRenderer;
                        label = renderer == null ? (JLabel)StatusTree.this.defaultRenderer.getHeadline(status) : (JLabel)renderer.getHeadline(status);
                    }
                    if (isSelected) {
                        label.setOpaque(true);
                        label.setBackground(this.getBackgroundSelectionColor());
                        label.setForeground(this.getTextSelectionColor());
                    } else {
                        label.setBackground(this.getBackgroundNonSelectionColor());
                        label.setForeground(this.getTextNonSelectionColor());
                    }
                } else {
                    label = new JLabel(nodeData.name);
                }
                StatusCode code = StatusCode.UNKNOWN;
                if (isLeaf && nodeData.status != null) {
                    code = nodeData.status.getCode();
                } else if (StatusGroupTreeNode.class.isInstance(node)) {
                    code = ((StatusGroupTreeNode)StatusGroupTreeNode.class.cast(node)).getStatusCode();
                }
                if (code.equals((Object)StatusCode.ERROR)) {
                    label.setIcon(ApplicationImages.RED_BALL_16);
                } else if (code.equals((Object)StatusCode.WARNING)) {
                    label.setIcon(ApplicationImages.YELLOW_BALL_16);
                } else {
                    label.setIcon(ApplicationImages.GREEN_BALL_16);
                }
                return label;
            }
        };
        this.setCellRenderer(renderer);
        ToolTipManager.sharedInstance().registerComponent(this);
    }
}

