/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.report.implementations;

import csbase.client.applications.algorithmsmanager.report.core.AbstractRemoteTest;
import csbase.client.applications.algorithmsmanager.report.core.IResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.ResultMessage;
import csbase.client.applications.algorithmsmanager.report.core.TestStatus;
import csbase.exception.algorithms.AlgorithmNotFoundException;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public class TestConfiguratorInvalid
extends AbstractRemoteTest<AlgorithmInfo> {
    public TestConfiguratorInvalid(Window taskWindow) {
        super(taskWindow, LNG.get((String)"TestConfiguratorInvalid.task.title"), LNG.get((String)"TestConfiguratorInvalid.task.message"));
    }

    @Override
    public List<IResultMessage<AlgorithmInfo>> doTest(AlgorithmInfo algorithmInfo) {
        ArrayList<IResultMessage<AlgorithmInfo>> list = new ArrayList<IResultMessage<AlgorithmInfo>>();
        for (AlgorithmVersionInfo version : algorithmInfo.getVersions()) {
            ResultMessage<AlgorithmInfo> message;
            if (version == null) continue;
            try {
                ClientRemoteLocator.algorithmService.createAlgorithmConfigurator(algorithmInfo.getName(), version.getId());
                ResultMessage<AlgorithmInfo> message2 = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.OK, LNG.get((String)"TestConfiguratorInvalid.valid", (Object[])new String[]{version.toString()}));
                list.add(message2);
            }
            catch (AlgorithmNotFoundException notFound) {
                message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.ERROR, LNG.get((String)"TestConfiguratorInvalid.invalid", (Object[])new String[]{version.toString()}));
                list.add(message);
            }
            catch (Exception e) {
                message = new ResultMessage<AlgorithmInfo>(algorithmInfo, TestStatus.ERROR, LNG.get((String)"TestConfiguratorInvalid.exception", (Object[])new String[]{version.toString(), e.getMessage()}));
                list.add(message);
            }
        }
        return list;
    }

    @Override
    public String getName() {
        return LNG.get((String)"TestConfiguratorInvalid.name");
    }

    @Override
    public String getDescription() {
        return LNG.get((String)"TestConfiguratorInvalid.description");
    }

    @Override
    public Class<AlgorithmInfo> getSubjectClass() {
        return AlgorithmInfo.class;
    }

    @Override
    public String getSubjectName(AlgorithmInfo subject) {
        return subject.getName();
    }
}

