/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import csbase.client.applications.ApplicationImages;
import csbase.logic.algorithms.AlgorithmConfigurator;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tecgraf.javautils.gui.tree.DefaultNode;
import tecgraf.javautils.gui.tree.Node;

public class AlgorithmVersionTreeNode
extends DefaultNode
implements Comparable<AlgorithmVersionTreeNode> {
    private final AlgorithmVersionInfo algorithmVersion;
    private final ImageIcon icon;

    public AlgorithmVersionTreeNode(AlgorithmVersionInfo algorithmVersionInfo) {
        super(algorithmVersionInfo.getId().toString(), Node.FiltrageMode.IGNORE);
        this.algorithmVersion = algorithmVersionInfo;
        this.icon = AlgorithmVersionTreeNode.getIconForVersion(algorithmVersionInfo);
    }

    static ImageIcon getIconForVersion(AlgorithmVersionInfo algorithmVersion) {
        if (algorithmVersion != null) {
            AlgorithmConfigurator.ConfiguratorType type = algorithmVersion.getType();
            if (type == AlgorithmConfigurator.ConfiguratorType.SIMPLE) {
                return ApplicationImages.ICON_FLOW_NODE_16;
            }
            if (type == AlgorithmConfigurator.ConfiguratorType.FLOW) {
                return ApplicationImages.ICON_FLOW_16;
            }
        }
        return ApplicationImages.ICON_BLANK_16;
    }

    @Override
    public int compareTo(AlgorithmVersionTreeNode node) {
        return this.getAlgorithmVersion().compareTo(node.getAlgorithmVersion());
    }

    public AlgorithmVersionInfo getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public Icon getIcon() {
        return this.icon;
    }
}

